/* CMSynergyVer %full_filespec: enet_hrc.h;2.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - Host Reference Configuration
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/drivers/enet_hrc.h $
 **
 ** DESCRIPTION:    C Structures For Access To Host Reference Config
 **
 ** AUTHOR:         IFO
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ** $Log: xxx $
 ** Revision 1.6  2001/11/21 15:40:09Z  lde
 ** Add control for legacy mode DMA.
 ** Revision 1.5  2001/11/15 14:42:34Z  lde
 ** Updated HRC memory map
 ** Revision 1.4  2001/11/08 12:20:04Z  ifo
 ** Cleaned up for boot loader use.
 ** Revision 1.3  2001/10/12 10:57:22Z  ifo
 ** Added host to card doorbell enums
 ** Revision 1.2  2001/10/05 10:14:29Z  lde
 ** Clearer naming of one of the DMA registers.
 ** Revision 1.1  2001/08/16 09:43:09Z  ifo
 ** ENET drivers added.
 **
 ****************************************************************************
 **
 ** Copyright (c) 2001 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef ENET_HRC_INCLUDED_H
#define ENET_HRC_INCLUDED_H

#include "System_GlobalDefinitions.h"



/* due to bug in the HYP3 we need to multiply each register offset by 4 
   the macro used to be more easy to build PCIE structure */
#define FIX_ADDRESS(x,n) uint32 x; 



/***************************************************************************/
/***                             Types                                   ***/
/***************************************************************************/





/***************************************************************************/
/***                    HRC: Run Time                                    ***/
/***************************************************************************/



typedef struct ENET_HRC_HRT
{
    /* 0x00 HRC GPIO input register */
    uint32  u32GPIOin;
    /* 0x04 HRC GPIO output register */
    uint32  u32GPIOout;
    /* 0x08 HRC GPIO output enable */
    uint32  u32GPIOoutEnable;
    /* 0x0C Host semaphore */
    uint32  u32HostSemaphore;
    /* 0x10 Paging register */
    uint32  u32PagingRegister;
    /* 0x14 Force interrupt (test use only) */
    uint32  u32ForceLocalInterrupt;
    /* 0x18 Reserved */
    uint32  au32Reserved1[2];
    /* 0x20 HRC DMA source/destination address in PCI memory space */
    uint32  u32DMAhostBaseAddress;
    /* 0x24 DMA HS cursor */
    uint32  u32DMAhsCursor;
    /* 0x28 HRC DMA destinatin/source address in PAS memory space */
    uint32  u32DMApasAddress;
    /* 0x2C HRC DMA length in bytes */
    uint32  u32DMAlength;
    /* 0x30 HRC DMA configuration */
    uint32  u32DMAconfiguration;
    /* 0x34 HRC DMA command */
    uint32  u32DMAcommand;
    /* 0x38 HRC DMA status */
    uint32  u32DMAstatus;
    /* 0x3C Reserved */
    uint32  au32Reserved2[9];
    /* 0x60 Local to Host interrupt */
    uint32  u32LocalInterruptCommand;
    /* 0x64 Local semaphore */
    uint32  u32LocalSemaphore;
    /* 0x68 Setup for expansion memory #0 */
    uint32  u32HemSRAM0waitStates;
    /* 0x6C Setup for expansion memory #1 */
    uint32  u32HemSRAM1waitStates;
} ENET_HRC_HRT;

typedef struct ENET_PCIE
{
    /* 0x00 */
    FIX_ADDRESS(u32aIntStatus,0)
    /* 0x10 */
    FIX_ADDRESS(u32aRawIntStatus,1)
    /* 0x20 */
    FIX_ADDRESS(u32aIntMask,2)
    /* 0x30 */
    FIX_ADDRESS(u32aIntClr,3)
    /* 0x40 */
    FIX_ADDRESS(u32bIntStatus,4)
    /* 0x50 */
    FIX_ADDRESS(u32bRawIntStatus,5)
    /* 0x60 */
    FIX_ADDRESS(u32bIntMask,6)
    /* 0x70 */
    FIX_ADDRESS(u32bIntClr,7)
    /* 0x80 */
    FIX_ADDRESS(u32ch0Ctrl,8)
    /* 0x90 */
    FIX_ADDRESS(u32ch0Config,9)
    /* 0xa0 */
    FIX_ADDRESS(u32ch0SrcType,10)
    /* 0xb0 */
    FIX_ADDRESS(u32ch0SrcAddress,11)
    /* 0xc0 */
    FIX_ADDRESS(u32ch0SrcDescrypt,12)
    /* 0xd0 */
    FIX_ADDRESS(u32ch0SrcLL_startPtr,13)
    /* 0xe0 */
    FIX_ADDRESS(u32ch0SrcLL_bufAddress,14)
    /* 0xf0 */
    FIX_ADDRESS(u32ch0SrcLL_nextDescrypt,15)
    /* 0x100 */
    FIX_ADDRESS(u32ch0SrcLL_ctrl,16)
    /* 0x110 */
    FIX_ADDRESS(u32ch0DestType,17)
    /* 0x120 */
    FIX_ADDRESS(u32ch0DestAddress,18)
    /* 0x130 */
    FIX_ADDRESS(u32ch0DestDescrypt,19)
    /* 0x140 */
    FIX_ADDRESS(u32ch0DestLL_startPtr,20)
    /* 0x150 */
    FIX_ADDRESS(u32ch0DestLL_bufAddress,21)
    /* 0x160 */
    FIX_ADDRESS(u32ch0DestLL_nextDescrypt,22)
    /* 0x170 */
    FIX_ADDRESS(u32ch0DestLL_ctrl,23)

    /* 0x180 */
    FIX_ADDRESS(u32ch1Ctrl,24)
    /* 0x190 */
    FIX_ADDRESS(u32ch1Config,25)
    /* 0x1a0 */
    FIX_ADDRESS(u32ch1SrcType,26)
    /* 0x1b0 */
    FIX_ADDRESS(u32ch1SrcAddress,27)
    /* 0x1c0 */
    FIX_ADDRESS(u32ch1SrcDescrypt,28)
    /* 0x1d0 */
    FIX_ADDRESS(u32ch1SrcLL_startPtr,29)
    /* 0x1e0 */
    FIX_ADDRESS(u32ch1SrcLL_bufAddress,30)
    /* 0x1f0 */
    FIX_ADDRESS(u32ch1SrcLL_nextDescrypt,31)
    /* 0x200 */
    FIX_ADDRESS(u32ch1SrcLL_ctrl,32)
    /* 0x210 */
    FIX_ADDRESS(u32ch1DestType,33)
    /* 0x220 */
    FIX_ADDRESS(u32ch1DestAddress,34)
    /* 0x230 */
    FIX_ADDRESS(u32ch1DestDescrypt,35)
    /* 0x240 */
    FIX_ADDRESS(u32ch1DestLL_startPtr,36)
    /* 0x250 */
    FIX_ADDRESS(u32ch1DestLL_bufAddress,37)
    /* 0x260 */
    FIX_ADDRESS(u32ch1DestLL_nextDescrypt,38)
    /* 0x270 */
    FIX_ADDRESS(u32ch1DestLL_ctrl,39)

    /* 0x280 */
    FIX_ADDRESS(u32DmacCtrl_ctrl,40)


} ENET_PCIE;


typedef struct ENET_HRC
{
    union
    {
        ENET_HRC_HRT    sPCI;
        ENET_PCIE       sPCIE;
    } u;

} ENET_HRC;


/* HRC/HRT GPIO - 4 bits of general purpose I/O */
/* hrc_gpio_in, u32GPIOin, HRC GPIO input register */
/* hrc_gpio_out, u32GPIOout, HRC GPIO output register */
/* hrc_gpio_output_enable, u32GPIOoutEnable, HRC GPIO output enable */
#define ENET_HRT_GPIO_MASK              0x0000000F

/* HIS: HRC/HRT Host interrupt status, host_interrupt_status, u32HostInterruptStatus */
#define ENET_HRT_HIS_LOCAL_SIG_TO_HOST  0x00000001
#define ENET_HRT_HIS_LOCAL_REG_TO_HOST  0x00000002
#define ENET_HRT_HIS_HOST_INIT_DMA_COMP 0x00000004

/* HIE: HRC/HRT Host interrupt enable mask, u32HostInterruptEnable, host_interrupt_enable */
/* 1=interrupt enable */
#define ENET_HRT_HIE_LOCAL_SIG_TO_HOST  0x00000001
#define ENET_HRT_HIE_LOCAL_REG_TO_HOST  0x00000002
#define ENET_HRT_HIE_HOST_INIT_DMA_COMP 0x00000004

/* HSM: HRC/HRT Host semaphore, u32HostSemaphore, host_semaphore */
#define ENET_HRT_HSM_MASK               0x0000000F

/* HIT: Host to local interrupt, u32HostToLocalDoorBellInterrupt, host_to_local_doorbell_interrupt */
/* Write a 1 to cause interrupt in the local CPU - normally written by Host */
/* 4 bits */
#define ENET_HRT_HIT_MASK               0x0000000F

/* HLD: Host to local doorbell - 4 off */
#define ENET_HRT_HLD_DOORBELL0          0x00000001
#define ENET_HRT_HLD_DOORBELL1          0x00000002
#define ENET_HRT_HLD_DOORBELL2          0x00000004
#define ENET_HRT_HLD_DOORBELL3          0x00000008

/* FLI: force interrupt (test use only), force_local_interrupt, u32ForceLocalInterrupt */
#define ENET_HRT_FLI_DMA_COMP           0x00000001
#define ENET_HRT_FLI_TEST_ABORT         0x00000002
#define ENET_HRT_FLI_TARGET_ABORT       0x00000004
#define ENET_HRT_FLI_MASTER_ABORT       0x00000008
#define ENET_HRT_FLI_SYS_ERR            0x00000010
#define ENET_HRT_FLI_DET_PARITY         0x00000020

/* DHA: DMA source/destination address in PCI memory space, dma_host_address, u32DMAhostAddress */
/* 32 bits */

/* DDA: DMA destinatin/source address in PAS memory space, dma_local_adress, u32DMAlocalAddress */
/* 32 bits */

/* DLN: DMA length in bytes, dma_length, u32DMAlength */
/* 16 bits */
#define ENET_HRT_DLN_MAX_LENGTH         0x0000FFFF

/* DCF: DMA configuration, dma_configuration, u32DMAconfiguration */
#define ENET_HRT_DCF_SELECT_EXP_MEM     0x00000001
#define ENET_HRT_DCF_LEGACY_MODE        0x00000002

/* DCM: DMA command, dma_command, u32DMAcommand */
/* Starts DMA and generates host interrupt at end */
#define ENET_HRT_DCM_HOST_START         0x00000001
/* Starts DMA and generates local interrupt at end */
#define ENET_HRT_DCM_LOCAL_START        0x00000002
/* Direction of DMA transfer */
#define ENET_HRT_DCM_HOST_TO_LOCAL      0x00000000
#define ENET_HRT_DCM_LOCAL_TO_HOST      0x00000004

/* DST: DMA status, dma_status, u32DMAstatus */
#define ENET_HRT_DST_INACTIVE           0x00000000
#define ENET_HRT_DST_HOST_BUSY          0x00000001
#define ENET_HRT_DST_LOCAL_BUSY         0x00000002
#define ENET_HRT_DST_ACTIVITY_MASK      0x00000003

/* LIC: Local to Host interrupt, local_interrupt_command, u32LocalInterruptCommand */
#define ENET_HRT_LIC_INTERRUPT_HOST     0x00000001

/* LSM: Local semaphore, local_semaphore, u32LocalSemaphore */
/* 8 bits */
/* Write a 1 to attempt to toggle a bit.  Can only set to 1 if the corresponding u32HostSemaphore is clear */
#define ENET_HRT_LSM_MASK               0x000000FF

/* Host Expansion Memory (HEM1/2) waits states */
#define ENET_HRT_HEM_SETUP_MASK         0x0000000F
#define ENET_HRT_HEM_SETUP_SHIFT        0
#define ENET_HRT_HEM_ACTIVE_MASK        0x000000F0
#define ENET_HRT_HEM_ACTIVE_SHIFT       4
#define ENET_HRT_HEM_HOLD_MASK          0x00000F00
#define ENET_HRT_HEM_HOLD_SHIFT         8
#define ENET_HRT_HEM_USE_EXTERNAL_WAIT  0x00001000

/*EEPROM - EEPROM configuration */
#define REG_LOCAL_EEPROM						0xC0
#define REG_LOCAL_EEPROM_OVERRIDE				0x00000001
#define REG_LOCAL_EEPROM_CLOCK_OUTPUT			0x00000020
#define REG_LOCAL_EEPROM_CLOCK_OUTPUT_ENABLE    0x00000040
#define REG_LOCAL_EEPROM_DATA_OUTPUT			0x00000200
#define REG_LOCAL_EEPROM_OUTPUT_ENABLE			0x00000400

/*   EEPROM commands  */
#define EEPROM_CTRL_WORD_1	0x41	/*OE="0" SDA="0" SCL="0"*/
#define EEPROM_CTRL_WORD_2	0x61	/*OE="0" SDA="0" SCL="1"*/
#define EEPROM_CTRL_WORD_3  0x441	/*OE="1" SDA="0" SCL="0"*/
#define EEPROM_CTRL_WORD_4  0x461	/*OE="1" SDA="0" SCL="1"*/
#define EEPROM_CTRL_WORD_5  0x641	/*OE="1" SDA="1" SCL="0"*/
#define EEPROM_CTRL_WORD_6  0x661   /*OE="1" SDA="1" SCL="1"*/
/***************************************************************************/
/***                        HRC: Config                                  ***/
/***************************************************************************/

typedef struct ENET_HRC_CFG
{
    /* Vendor and device ID */
    uint32  u32DeviceInfo;
    /* Command and status register */
    uint32  u32CmdStat;
    /* Revision and class ID */
    uint32  u32RevClass;
    /* Latency and BIST */
    uint32  u32LateBist;
    /* Base address register 0 */
    uint32  u32PASbaseAddressRegister;
    /* Base address register 1 */
    uint32  u32HRCruntimeBaseAddressRegister;
    /* Reserved */
    uint32  u32Reserved1[4];
    /* Not writable via CardBus host */
    uint32  u32CardBusCISpointer;
    /* Subsystem info */
    uint32  u32SubSystemInfo;
    /* Reserved */
    uint32  u32Reserved2[3];
    /* Grant, latency, interrupt line */
    uint32  u32GrantLate;
    /* PAS base address register range */
    uint32  u32PASbaseAddressRegisterRange;
    /* HRC runtime base address register range */
    uint32  u32HRCruntimeBaseAddressRegisterRange;
    /* Target configuration */
    uint32  u32TargetConfiguration;
    /* Initiator configuration */
    uint32  u32InitiatorConfiguration;
    /* Reserved */
    uint32  u32Reserved3[2];
    /* Register to write to EEPROM */
    uint32  u32EEPROMoverride;
    /* EEPROM controller configuration */
    uint32  u32EEPROMcontrolConfiguration;
    /* EEPROM executive configuration */
    uint32  u32EEPROMexecutiveConfiguration;
    /* EEPROM executive status */
    uint32  u32EEPROMexecutiveStatus;
    /* Initialisation status */
    uint32  u32ConfigInitialisationStatus;
    /* Local CPU boot configuration (override) */
    uint32  u32LocalBootConfiguration;
} ENET_HRC_CFG;

/***************************************************************************/
/***                          Public Data                                ***/
/***************************************************************************/



/***************************************************************************/
/***                     Public Function Prototypes                      ***/
/***************************************************************************/

#endif /* ENET_HRC_INCLUDED */
