/* CMSynergyVer %full_filespec: enet_pas.h;7.1.2.5.1.1.4:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/drivers/enet_pas.h $
 **
 ** DESCRIPTION:    Register definitions for PAS
 **
 ** AUTHOR:         John Gladman
 **
 ** THIS VERSION:   $Revision: #2 $
 **   CHANGED ON:   $Date: 2004/02/16 $
 **           BY:   $Author: prh $
 **
 ** $Log: enet_pas.h $
 ** Revision 1.3  2003/02/18 13:15:59Z  prh
 ** Do not restrict use of RSN defines.
 ** Revision 1.2  2003/02/12 17:35:09Z  wrh
 ** Overwrite
 ** Revision 1.2  2002/12/18 13:57:45Z  wrh
 ** New definitions for TKIP
 ** Revision 1.1  2002/12/03 12:51:35Z  wrh
 ** Initial revision
 ** Revision 1.28  2002/10/09 13:53:58Z  wrh
 ** Add A2 register for CCM mode encryption
 ** Revision 1.27  2002/10/04 10:24:25Z  wrh
 ** Added hardware_id register for encryption block
 ** Revision 1.26  2002/09/25 12:01:19Z  wrh
 ** Corrected couple of typos on encryption registers and moved conditional #if to correct place
 ** Revision 1.25  2002/07/25 12:44:43Z  wrh
 ** Add Encryption Modes Wrapper
 ** Revision 1.24  2002/07/24 08:46:50Z  wrh
 ** Corrected typos
 ** Revision 1.23  2002/07/23 15:16:05Z  wrh
 ** WEP registers now accessed via Encryption Modes Wrapper - note:
 ** this is designed to be backwardly compatible ie WEP register addresses
 ** resolve to the same values as before
 ** Revision 1.22  2002/04/25 13:37:09Z  ifo
 ** Added shifts for duration block settings in SHRAM.
 ** Revision 1.21  2002/04/24 10:25:00Z  smk
 ** new meaning of bit 30 in IFSa field
 ** Revision 1.20  2002/04/12 07:39:05Z  jag1
 ** Corrected typo.
 ** Revision 1.19  2002/04/09 14:20:42Z  ifo
 ** Added macro for TTCS resolution (8)
 ** Revision 1.18  2002/04/08 11:36:42Z  smk
 ** update to duration block for RTL 2.0
 ** Revision 1.17  2002/03/19 16:23:07Z  ifo
 ** Added comments for TIM block - cn11090_42
 ** Revision 1.16  2002/03/19 14:59:01Z  ifo
 ** cn11090_33 Modified row in RXD decision block.
 ** Added regy frame_abort in RXD - frame_abort, currently unused.
 ** Revision 1.15  2002/03/19 14:05:51Z  ifo
 ** cn11090_32 - New CLC (CLock control) regy's - note normally don't have to touch these
 ** Revision 1.14  2002/03/19 13:45:04Z  ifo
 ** cn11090_29 - Removed support for old WEP unit with fixed key length.
 ** Revision 1.13  2002/03/19 13:23:55Z  ifo
 ** cn11090_28 - Added version number register to RAB.
 ** Revision 1.12  2002/03/19 13:13:59Z  ifo
 ** CN11090_25, Chnage in size of DurationAdjust from 8 to 10 bits per entry
 ** Revision 1.11  2002/03/19 10:05:57Z  jag1
 ** Added Delia CSE instruction.
 ** Revision 1.10  2002/03/01 09:19:58Z  jag1
 ** Fixed typo in #define (PTR)
 ** Revision 1.9  2002/01/28 15:49:09Z  djh
 ** Changed the WEP hardware stuff for new register map. To use old
 ** version define WEP_OLD_VERSION for the compiler
 ** Revision 1.8  2002/01/28 15:43:46Z  jag1
 ** Modified Deila's End instruction.
 ** Revision 1.7  2002/01/22 13:10:04Z  jag1
 ** Added another TIM definition.
 ** Revision 1.6  2001/12/20 10:00:55Z  jgs
 ** Brought into line with coding standard
 ** Revision 1.5  2001/12/04 10:28:52Z  ifo
 ** Updated headers.
 ** Removed tabs.
 ** No functional changes.
 **
 ****************************************************************************
 **
 ** Copyright (c) 2001 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef PAS_DEFS_INCLUDED
#define PAS_DEFS_INCLUDED

#include "System_GlobalDefinitions.h"


/*********************************************/
/* Definitions for the Register Access Block */
/*********************************************/


#define RAB_HOST_INT_INDEX  0

 
/************************************/
/* Definitions for TTCS */
/************************************/
typedef struct ENET_TTCS /* Transmit Timing Control Structure */
{
    uint32  u32IFSa;
    uint16  u16IFSb;
    uint16  u16Backoff;
    uint32  u32RspTimeoutCtrl;
    uint32  u32Recipe0;
} ENET_TTCS;

/* Pointer table definitions */

#define NUM_OF_PTCS_PTR_ENTRIES 64
 

#define DUR_ACK_CTRL_NO_ACK0_MSK        (0x1U << 0)
#define DUR_ACK_CTRL_NO_ACK1_MSK        (0x1U << 1)
#define DUR_ACK_CTRL_NO_ACK2_MSK        (0x1U << 2)
#define DUR_ACK_CTRL_NO_ACK3_MSK        (0x1U << 3)
#define DUR_ACK_CTRL_NO_ACK_CAT_MSK     (0x1U << 4)
 


#endif
