/* CMSynergyVer %full_filespec: int_gen.h;3.1.1.1.1.1.5:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/drivers/int_gen.h $
 **
 ** DESCRIPTION:    Interrupt generation code.
 **                 This driver provides a mechanism for one CPU (or module)
 **                 to communicate with another by generating interrupts
 **                 to it.
 **
 ** AUTHOR:         IFO
 **
 ** THIS VERSION:   $Revision: #4 $
 **   CHANGED ON:   $Date: 2004/03/31 $
 **           BY:   $Author: prh $
 **
 ** $Log: int_gen.h $
 ** Revision 1.6  2002/02/25 16:19:32Z  ifo
 ** Added support for test upper mac
 ** Revision 1.5  2001/12/04 10:28:54Z  ifo
 ** Updated headers.
 ** Removed tabs.
 ** No functional changes.
 ** Revision 1.4  2001/11/26 10:49:11Z  ifo
 ** Cleaned up function comments.
 ** Revision 1.3  2001/10/12 10:57:01Z  ifo
 ** Added Host to Card interrupt generation routine (for test host).
 ** Revision 1.2  2001/08/16 09:43:57Z  ifo
 ** ENET drivers added.
 ** Revision 1.1  2001/06/15 13:44:42Z  ifo
 ** Initial revision
 **
 ****************************************************************************
 **
 ** Copyright (c) 2001 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef INT_GEN_INCLUDED_H
#define INT_GEN_INCLUDED_H

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/***************************************************************************/
/***                              Defines                                ***/
/***************************************************************************/
#define IGEN_SPECIFY_EVENT(x) (1U << x)
#define IGEN_INCREASE_EVENT(orig_event,increment) (orig_event << increment)
#define IGEN_CHECK_MASK(signalMask,bit) ((signalMask & bit) == 0)
#define IGEN_CLEAR_MASK(signalMask,bit) (signalMask &= (~bit))
#define IGEN_SET_MASK(signalMask,bit) (signalMask |= bit) 

/* The first DCF CFM ID          */
#define  EVT_DCF_CFM_INTRPT      18



// LM0 int map
#define IGEN_EVT_IPC_TO_LM0_FROM_UM		IGEN_SPECIFY_EVENT(0)
#define IGEN_EVT_IPC_TO_LM0_FROM_LM1	IGEN_SPECIFY_EVENT(1)
#define IGEN_EVT_ASSERT_TO_LM0_FROM_UM	IGEN_SPECIFY_EVENT(2)
#define IGEN_EVT_ASSERT_TO_LM0_FROM_LM1	IGEN_SPECIFY_EVENT(3)
// LM1 int map
#define IGEN_EVT_IPC_TO_LM1_FROM_UM		IGEN_SPECIFY_EVENT(0)
#define IGEN_EVT_IPC_TO_LM1_FROM_LM0	IGEN_SPECIFY_EVENT(1)
#define IGEN_EVT_ASSERT_TO_LM1_FROM_UM	IGEN_SPECIFY_EVENT(2)
#define IGEN_EVT_ASSERT_TO_LM1_FROM_LM0	IGEN_SPECIFY_EVENT(3)

#define IGEN_EVT_ATIM_REQ				IGEN_SPECIFY_EVENT(4)
#define IGEN_EVT_DCF_REQ				IGEN_SPECIFY_EVENT(5)
#define IGEN_EVT_TXQS_REQ				IGEN_SPECIFY_EVENT(6)
#define IGEN_EVT_RX_RES					IGEN_SPECIFY_EVENT(7)
#define IGEN_EVT_DEBUG_RES				IGEN_SPECIFY_EVENT(8)

// UM int map
#define IGEN_EVT_IPC_TO_UM_FROM_LM0		IGEN_SPECIFY_EVENT(0)
#define IGEN_EVT_IPC_TO_UM_FROM_LM1		IGEN_SPECIFY_EVENT(1)
#define IGEN_EVT_ASSERT_TO_UM_FROM_LM0	IGEN_SPECIFY_EVENT(2)
#define IGEN_EVT_ASSERT_TO_UM_FROM_LM1	IGEN_SPECIFY_EVENT(3)

#define IGEN_EVT_CF_CFM					IGEN_SPECIFY_EVENT(11)
#define IGEN_EVT_UPS_CFM				IGEN_SPECIFY_EVENT(12)
#define IGEN_RESERVED					IGEN_SPECIFY_EVENT(13)
#define IGEN_EVT_DCF_CFM				IGEN_SPECIFY_EVENT(14)
#define IGEN_EVT_TXQS_CFM				IGEN_SPECIFY_EVENT(15)
#define IGEN_EVT_RX_IND					IGEN_SPECIFY_EVENT(16)
#define IGEN_EVT_DEBUG_IND				IGEN_SPECIFY_EVENT(17)
#define IGEN_EVT_DCF_CFM_P0				IGEN_SPECIFY_EVENT(EVT_DCF_CFM_INTRPT /* 18 */)
#define IGEN_EVT_DCF_CFM_P1				IGEN_SPECIFY_EVENT(19)
#define IGEN_EVT_DCF_CFM_P2				IGEN_SPECIFY_EVENT(20)
#define IGEN_EVT_DCF_CFM_P3				IGEN_SPECIFY_EVENT(21)
#define IGEN_EVT_AGG_NACK				IGEN_SPECIFY_EVENT(22)
#define IGEN_EVT_BA_DESC				IGEN_SPECIFY_EVENT(23)


#define OTHER_CPU_TABLE_SIZE    24       // Must be one greater than number of interrupts
typedef void (*P_ISR)(void);
extern const P_ISR apOtherCpuISR[OTHER_CPU_TABLE_SIZE];

/***************************************************************************/
/***                              Types                                  ***/
/***************************************************************************/

/***************************************************************************/
/***                     Public Function Prototypes                      ***/
/***************************************************************************/



#endif /* INT_GEN_INCLUDED_H */

