/*****************************************************************************
*   MODULE NAME:
*       mt_addr_sharing.c	 
*   DESCRIPTION: 
*       host-MIPS and Lower-Upper protocol definitions
*   AUTHOR:  
*       roi
*   DATE: 

*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any   
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/

#include "mt_addr_sharing_defines.h" 

#include "lmi.h"
#include "CalibrationHandler.h"
#include "CalibrationHandlerStatistics.h"
#include <TpcClbrHndlr.h>
#include "ErrorHandler_Api.h"
#include "mt_phy_statistics.h"
#include "shram.h"

/* add here #includes to all the headers from which you want to import variables,
   or add "extern" declarations to the shared variables*/
extern FW_CORE_CONTROL_DESCRIPTOR u32FwCoreControlDesc;


/* variables that manage MT_LOG interface */
extern const char 	version_info[200];
extern uint32 		errorHandlerEpcReg;
 
#if defined (ENET_INC_LMAC)
	/* Include + extern statement for Lower CPU */
	#if defined(ENET_INC_DEBUG_LM_STATS)
	#include "lm_statistics.h"
	extern uint32 MT_LM_STAT_GENERAL[MT_LM_STAT_GENERAL_TOTAL_NUM];
	extern uint32 MT_LM_STAT_PER_PRIORITY[MAX_USER_PRIORITIES][MT_LM_STAT_PER_PRIORITY_TOTAL_NUM];
	#endif /* #if defined(ENET_INC_DEBUG_LM_STATS) */
#endif

#include "um_interface.h"
#include "lm_interface.h"

//#include "mt_debug.h"
#include "MT_shram_alignment.h"
#include "TpcClbrHndlr.h"
//#define MT_GLOBAL
#include "mt_addr_sharing.h"
//#undef MT_GLOBAL

#if defined(ENET_INC_UMAC) 
#define MT_ADDR_SHAR_LOCAL_CHIPVAR_COUNT (sizeof(mt_umlocalChipVarStructs) / sizeof(MT_ADDR_SHARING_VAR_STRUCT))
#elif defined(ENET_INC_LMAC0)
#define MT_ADDR_SHAR_LOCAL_CHIPVAR_COUNT (sizeof(mt_lm0localChipVarStructs) / sizeof(MT_ADDR_SHARING_VAR_STRUCT))
#elif defined(ENET_INC_LMAC1)
#define MT_ADDR_SHAR_LOCAL_CHIPVAR_COUNT (sizeof(mt_lm1localChipVarStructs) / sizeof(MT_ADDR_SHARING_VAR_STRUCT))
#endif

#define MT_ADDR_SHAR_SINGLE_CPU		(1)
#define MT_ADDR_SHAR_DUAL_CPU		(2)
#define MT_ADDR_SHAR_TRIPLE_CPU		(3)

/* define the main chipvar variable list: pointers to all needed variables */


MAP_TO_SECTION(bss, ".SHARED_RAM_ADDR_SHARING")
MT_ADDR_SHARING_ANCHOR_T anchor;
MAP_TO_DEFAULT_SECTION(bss)

/* this macro accepts a pointer in the context of the other CPU, and returns a pointer we can access from this CPU */
/* todo: roi recieve pointers to variables that reside in other sections (SHRAM, SDRAM etc), not only in A_K0BASE ) */
#define MT_PEER_PTR_ADDR_TRANSLATE(addr)         ( (MT_MIPS_POINTER_T)  (0xa0080000 - A_K0BASE + (uint32)addr) ) /* the cast to UINT32 is important to avoid pointers arithmetics */

/* this macro accepts a name of variable, and returns something that goes good as an item in an array of pointers to variables */
#define MT_PTR_TO_VAR_MACRO(var,type)             ((MT_MIPS_POINTER_T)(&var)),
#define MT_PTR_TO_VARPTR_MACRO(var,type)          ((MT_MIPS_POINTER_T)( var)),

#define _CHIPVAR_(var,cell_size)              {(MT_MIPS_POINTER_T)(&var), sizeof( var)/cell_size, cell_size}
#define _CHIPPTR_(var,cell_size)              {(MT_MIPS_POINTER_T)( var), sizeof( *var)/cell_size, cell_size}
#define _CHIPARRAY_(var,cell_size)              {(MT_MIPS_POINTER_T)( var), sizeof( var)/cell_size, cell_size}

#include "mt_addr_sharing_variables.h"
uint32 MT_ADDR_SHARING_localChipvarCount;
uint32 MT_ADDR_SHARING_peerChipvarCount;
uint32 MT_ADDR_SHARING_numOfCpu;// Number of cpus in the FW Gen3->2, Gen 3.5->1
uint32 MT_ADDR_SHARING_valid;

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_PERIPHERALS
#define LOG_LOCAL_FID 0

/***************************
 *
 * MT_ADDR_SHARING_Init
 *
 * This function runs only once in UCPU, and once in LCPU.
 * It initializes MT_ADDR_SHARING_peerChipvar.
 *
 * Algorithm:
 * ==========
 * This function is called from a location in the sysmain code, which runs in LCPU before it runs in UCPU. 
 * This is the reason for the asymmetry you can find here.
 * 
 * Shared Code
 * -----------
 * Both LCPU and UCPU update their localChipvarCount & peerChipvarCount variables (4 variables in both UCPU 
 * and LCPU together). Both LCPU and UCPU update the relative member of the anchor to point to their localChipvar 
 * respectively. This way other CPUs can access it.
 * 
 * UCPU-only Code
 * --------------
 * a. UCPU knows LCPU's chipvar's address by fetching it from the anchor. It loops thru it to copy its values to
 *	  UCPU's peerChipvar. Now UPCU can access LCPU's variables via UCPU's peerChipvar.
 *    Inside this loop UCPU checks that it was compiled with the same h file like the LCPU, and the number of chipvar
 *	  it thinks LCPU has is accurate, this can be done because we know the LCPU has its localChipvarCount set as a 
 *	  shared address in the beginning of the chipvar array.
 * b. Do the same for the LCPU: we loop thru its peerChipvar and copy into it UCPU localChipvar values.
 *    access to LCPU peerChipvar is done thanks to the fact that it is shared, and we got its address (among other
 *	  addresses) in stage a.
 */
uint32 MT_ADDR_SHARING_Initialized = 0;
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

void MT_ADDR_SHARING_Init()
{
	/* Error: variable anchor in mt_addr_sharing.c should be in in section .SHARED_RAM_ADDR_SHARING at 
     * addressMT_SHRAM_BASE_ADDRESS + 1fed8, because this is where host looks for it
	 * 
	 * Note: Driver and BBstudio use hard coded address for reading chipvar struct. Any change need to 
	 *		 be occure also at MIPS, driver and BBStudio.
     */    
    ASSERT((uint32)&anchor == MT_ADDR_SHARING_ANCHOR_ADDR);


    if (MT_ADDR_SHARING_Initialized)
        return;
    MT_ADDR_SHARING_Initialized = 1;
	
	/* write Chipvar address into the known address (anchor), so the host can look it up and read Chipvar */
    MT_ADDR_SHARING_localChipvarCount = MT_ADDR_SHAR_LOCAL_CHIPVAR_COUNT;

    MT_ADDR_SHARING_numOfCpu = MT_ADDR_SHAR_DUAL_CPU;
//    MT_ADDR_SHARING_peerChipvarCount  = MT_PEER_CHIPVAR_COUNT;

#if defined (ENET_INC_UMAC)
    anchor.ucpu_valid = 1;
#endif
#if defined (ENET_INC_LMAC0)
    anchor.lcpu0_valid = 1;
#endif

#if defined (ENET_INC_LMAC1)
    anchor.lcpu1_valid = 1;
#endif
    
#if defined (ENET_INC_LMAC0)

    anchor.addrChipvarLCPU0 = (MT_MIPS_POINTER_T) mt_lm0localChipVarStructs;
#endif

#if defined (ENET_INC_LMAC1)

    anchor.addrChipvarLCPU1 = (MT_MIPS_POINTER_T) mt_lm1localChipVarStructs;
#endif

#if defined (ENET_INC_UMAC)

    anchor.addrChipvarUCPU = (MT_MIPS_POINTER_T) mt_umlocalChipVarStructs;

#endif 
}
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default 
#endif


MT_ADDR_SHARING_VAR_STRUCT* MT_ADDR_SHARING_GetLocalVariableStruct(uint32 index)
{
	ASSERT(index < MT_ADDR_SHAR_LOCAL_CHIPVAR_COUNT);
#if defined(ENET_INC_UMAC)
    return &(mt_umlocalChipVarStructs[index]);

#elif defined(ENET_INC_LMAC0)
	return &(mt_lm0localChipVarStructs[index]);

#elif defined(ENET_INC_LMAC1)
	return &(mt_lm1localChipVarStructs[index]);

#endif
}




