/*****************************************************************************
*   MODULE NAME:
*       mt_addr_sharing.h
*   DESCRIPTION: 
*       host-MIPS and Lower-Upper protocol definitions
*
*       This file should be included both by MIPSs and hosts, so leave it as clean from
*       compilation problems and unnecessary #includes.
*
*       Important: This chipvar table is not for debug purposes. It's too expensive in mem space.
*                  To debug, use MIPS Variables Watch form, which is more flexible
*
*   AUTHOR:  
*       roi
*   DATE: 

*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any   
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/
#ifndef MT_ADDR_SHARING_MODULE__
#define MT_ADDR_SHARING_MODULE__
/* definitions */
//#if defined(MT_GLOBAL)
//   #define extern
//   #define MT_I(x) x
//#else
//   #define extern extern
//   #define MT_I(x)
//#endif
//#include "mt_addr_sharing_variables.h"
#include "mt_addr_sharing_defines.h"
/* API for public use of address sharing module */
void MT_ADDR_SHARING_Init(void);

typedef struct {
    MT_MIPS_POINTER_T ptr;         /* pointer to variable (if var is ptr, then itself) */
    uint32         cell_count;  /* total size of the whole var (if a ptr -> total size of the var pointed by it)*/
    uint32         cell_size;   /* size of one cell in an array, or the size of the var itself (if it's not a ptr) */
}MT_ADDR_SHARING_VAR_STRUCT;


/*
MT_MIPS_POINTER_T MT_ADDR_SHARING_GetVariablePtr(uint32 index);
*/
MT_ADDR_SHARING_VAR_STRUCT* MT_ADDR_SHARING_GetLocalVariableStruct(uint32 index);



extern uint32 MT_ADDR_SHARING_localChipvarCount;
extern uint32 MT_ADDR_SHARING_peerChipvarCount;
extern uint32 MT_ADDR_SHARING_numOfCpu;// Number of cpus in the FW Gen3->2, Gen 3.5->1

#if defined(ENET_INC_LMAC)

#define MT_LOCAL_CHIPVAR_COUNT                   MT_LCPU_CHIPVAR_COUNT
#define MT_PEER_CHIPVAR_COUNT                    MT_UCPU_CHIPVAR_COUNT
#define MT_PEER_ENUM_MACRO(var)                  MT_ADDR_SHARING_ENUM_MACRO(MT_UCPU_ENUM,var)
#define MT_LOCAL_ADDR_SHARING_CHIPVAR_LIST       MT_LCPU_ADDR_SHARING_CHIPVAR_LIST

#elif defined(ENET_INC_UMAC)

#define MT_LOCAL_CHIPVAR_COUNT                   MT_UCPU_CHIPVAR_COUNT
#define MT_PEER_CHIPVAR_COUNT                    MT_LCPU_CHIPVAR_COUNT
#define MT_PEER_ENUM_MACRO(var)                  MT_ADDR_SHARING_ENUM_MACRO(MT_LCPU_ENUM,var)
#define MT_LOCAL_ADDR_SHARING_CHIPVAR_LIST       MT_UCPU_ADDR_SHARING_CHIPVAR_LIST

#endif

/* global variables */

/* peerChipvar reflects addresses that are shared in the other CPU. Valid only after Init function has run */
/*extern  MT_MIPS_POINTER_T MT_ADDR_SHARING_peerChipvar [MT_PEER_CHIPVAR_COUNT];
*/
/* MT_ADDR_SHARING_valid starts false, gets 'true' only after a successful Init */
extern  uint32          MT_ADDR_SHARING_valid;


//#undef extern
//#undef MT_I
#endif
