/*****************************************************************************
*   MODULE NAME:
*       mt_addr_sharing_variables.h
*   DESCRIPTION: 
*       list of variables (both LCPU and UCPU) to be used by addr_sharing module
*
*   AUTHOR:  
*       roi
*   DATE: 

*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any   
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/
#ifndef MT_ADDR_SHARING_MODULE_DEFINES__
#define MT_ADDR_SHARING_MODULE_DEFINES__

#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "HwMemoryMap.h"
//#include "mt_addr_sharing_variables.h"

typedef uint32* MT_MIPS_POINTER_T;
/*
  location of anchor of AddressSharing protocol is defined in linker file mt_linker_wl.lnk as:
  .SHARED_RAM_ADDR_SHARING SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE.
  This #define is important for letting host know where the anchor is.
  Any changes in these parameters requires updating the MT_ADDR_SHARING_ANCHOR_ADDR below.
*/
#if defined (ENET_INC_ARCH_WAVE600)
#define MT_ADDR_SHARING_ANCHOR_ADDR (SHARED_RAM_BASE_ADDR + 0x1fed4)
#else
#define MT_ADDR_SHARING_ANCHOR_ADDR (SHARED_RAM_BASE_ADDR + 0x1fed8)
#endif
/* this typedef struct defines the structure of the anchor: it tells what are the init addresses 
 * of chipvar arrays of all CPUs
 */
typedef struct
{
    MT_MIPS_POINTER_T	addrChipvarLCPU0;
    MT_MIPS_POINTER_T	addrChipvarUCPU;
    MT_MIPS_POINTER_T	addrChipvarHost;	/*probably won't be in use (MIPS won't read host's variables), but reserve place for it anyway*/
    uint32				lcpu0_valid;   
    uint32				ucpu_valid;   
#if defined (ENET_INC_ARCH_WAVE600)
	MT_MIPS_POINTER_T	addrChipvarLCPU1;	/*WAVE600, 2nd LMAC*/
    uint32				lcpu1_valid;		/*WAVE600, 2nd LMAC*/
#endif
} MT_ADDR_SHARING_ANCHOR_T;


#endif
