/*****************************************************************************
*   MODULE NAME:
*       mt_addr_sharing_variables.h
*   DESCRIPTION: 
*       list of variables (both LCPU and UCPU) to be used by addr_sharing module
*
*   AUTHOR:  
*       roi
*   DATE: 

*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any   
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/
#ifndef MT_ADDR_SHARING_MODULE_VARIABLES__
#define MT_ADDR_SHARING_MODULE_VARIABLES__
#include "System_Configuration.h"
#include "System_Information.h"
#include "ShramErrorHandler.h"
#include "lm.h"
#include "CalibrationHandlerStatistics.h"
#include "MT_NSSMemoryPool.h"



extern uint32 cpuLoadArray[100];  // In gen5 - each entry represent ~0.1 second,  The total array gives perspective on 1sec. In gen6 - each entry is 1 second.


/* chipvar list 
   ------------
   - don't change order. add new vars only to end of list
   - if you need to cancel a variable, change it to NULL, and leave a "hole", but don't delete it
     this is in the sake of future version compatibility
*/
#if defined (ENET_INC_LMAC0)

//////////////////// LOWER 0 CPU Chip Variables ////////////////////////
MT_ADDR_SHARING_VAR_STRUCT mt_lm0localChipVarStructs[] =
{
/*  ptr/var              NAME OF VARIABLE                               SIZE OF ARRAY_CELL          */
/****************************************************************************************************/
/* 0 */     _CHIPVAR_           (MT_ADDR_SHARING_localChipvarCount,             sizeof(uint32)),
/* 1 */     _CHIPVAR_           (MT_ADDR_SHARING_peerChipvarCount,              sizeof(uint32)),
/* 2 */     _CHIPVAR_           (MT_ADDR_SHARING_numOfCpu,                      sizeof(uint32)),
/* 3 */     _CHIPVAR_           (MT_ADDR_SHARING_valid,                         sizeof(uint32)),
/* 4 */     _CHIPARRAY_         (version_info,                                  sizeof(char)),
/* lmFifoLog_p->uiFifoLog */
/* 5 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)), // will be initialized in MT_ADDR_SHARING_Init
/* lmFifoLog_p->uiFifoLogIdx */
/* 6 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)), // will be initialized in MT_ADDR_SHARING_Init
/* 7 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 8 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 9 */		_CHIPVAR_           (u32FwCoreControlDesc.u32FwCoreCtrl[CORE_NUM_0],	sizeof(uint32)),
};
#endif

#if defined (ENET_INC_LMAC1)

//////////////////// LOWER 1 CPU Chip Variables ////////////////////////
MT_ADDR_SHARING_VAR_STRUCT mt_lm1localChipVarStructs[] =
{
/*  ptr/var              NAME OF VARIABLE                               SIZE OF ARRAY_CELL          */
/****************************************************************************************************/
/* 0 */     _CHIPVAR_           (MT_ADDR_SHARING_localChipvarCount,             sizeof(uint32)),
/* 1 */     _CHIPVAR_           (MT_ADDR_SHARING_peerChipvarCount,              sizeof(uint32)),
/* 2 */     _CHIPVAR_           (MT_ADDR_SHARING_numOfCpu,                      sizeof(uint32)),
/* 3 */     _CHIPVAR_           (MT_ADDR_SHARING_valid,                         sizeof(uint32)),
/* 4 */     _CHIPARRAY_         (version_info,                                  sizeof(char)),
/* lmFifoLog_p->uiFifoLog */
/* 5 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)), // will be initialized in MT_ADDR_SHARING_Init
/* lmFifoLog_p->uiFifoLogIdx */
/* 6 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)), // will be initialized in MT_ADDR_SHARING_Init
/* 7 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 8 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 9 */		_CHIPVAR_           (u32FwCoreControlDesc.u32FwCoreCtrl[CORE_NUM_1],	sizeof(uint32)),
};
#endif

//////////////////// UPPER CPU Chip Variables ////////////////////////
#if defined (ENET_INC_UMAC)

MT_ADDR_SHARING_VAR_STRUCT mt_umlocalChipVarStructs[] =
{
/*  ptr/var              NAME OF VARIABLE                               SIZE OF ARRAY_CELL          */
/****************************************************************************************************/
/* 0 */     _CHIPVAR_           (MT_ADDR_SHARING_localChipvarCount,             sizeof(uint32)),
/* 1 */     _CHIPVAR_           (MT_ADDR_SHARING_peerChipvarCount,              sizeof(uint32)),
/* 2 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL ,					sizeof(MT_MIPS_POINTER_T)),
/* 3 */     _CHIPVAR_           (MT_ADDR_SHARING_valid,                         sizeof(uint32)),
/* 4 */     _CHIPARRAY_         (version_info,                                  sizeof(char)),
/* 5 */     _CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 6 */		_CHIPPTR_          	((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 7 */ 	_CHIPARRAY_			(cpuLoadArray,									sizeof(uint32)),
#if defined (HOST_MESSAGES_STATISTICS)
/* 8 */		_CHIPVAR_			(UMSTAT_HostIFStats,							sizeof(uint16)),
#else
/* 8 */ 	_CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
#endif	//HOST_MESSAGES_STATISTICS
/* 9 */		_CHIPPTR_          	((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 10 */	_CHIPVAR_           (u32FwCoreControlDesc.u32FwCoreCtrl[CORE_NUM_2],	sizeof(uint32)),
/* 11 */	_CHIPPTR_			((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
#if ((defined HDK_REL_2_0) || (defined HDK_INTERMEDIATE_UNTIL_API_MERGE)) //PHYTBD: open after merge with CDB and API lignment
/* 12 */ 	_CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
/* 13 */ 	_CHIPPTR_           ((MT_MIPS_POINTER_T)MT_NULL,					sizeof(MT_MIPS_POINTER_T)),
#else
/* 12 */ 	_CHIPPTR_			(CalibrationHandlersStatisticsPointer,			sizeof(uint32)),
/* 13*/		_CHIPVAR_		 	(offlineStatistics,								sizeof(uint32)),
#endif
};                                                                                
#endif                                                                          

#endif
