/* CMSynergyVer %full_filespec: mt_eeprom.h; */
/*****************************************************************************
*   Source File:
*       mt_eeprom.h
*   Product Name:
*       Metalink EEprom Interface task
*   Description: 							   
*        Read/Write data into Eeprom 
*   Copyright: 
*       (C) Metalink Ltd. 
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/
/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
#ifndef MT_EEPROM_H
#define MT_EEPROM_H

#define EEPROM_8K_LAST_ADRRESS 0x3FF
#define EEPROM_4K_LAST_ADRRESS 0x1FF
#define EEPROM_2K_LAST_ADRRESS 0xFF

#define EEPROM_TEST_VALUE 0xAE

#define OE_0_SDA_1_SCL_1   0x261

#define EEPROM_OPERATION_FAIL (0)
#define EEPROM_OPERATION_OK (1)

/******************************************************************************/
/***						Public Function Declaration						***/
/******************************************************************************/
#if !defined(ENET_INC_HW_FPGA)
  bool Eeprom_Write_Byte(uint32 address,uint8 data);
  bool Eeprom_Read_Byte(uint32 address,uint8 * pData);
#ifndef DISABLE_EEPROM_FW_SUPPORT
  void Eeprom_CalcSize(void);
  void EEPROM_Init(void);
#endif// DISABLE_EEPROM_FW_SUPPORT
#endif


#endif
