/***************************************************************
 File:		ProtectedDbLock_Api.h
 Module:	  	ProtectedDbLock
 Purpose: 	interface for ProtectedDbLock services 
 Description:  
***************************************************************/
#ifndef PROTECTED_DB_LOCK_API_H_
#define PROTECTED_DB_LOCK_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef void (*ProtectedDbLock_localModificationFunc)(uint32*, void* );

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void ProtectedDbLock_Initialize(void);
void ProtectedDbLock_ReadReq(uint32* destinationShramAddress, uint32 sizeInwords, uint32* scratchPadAddress);
void ProtectedDbLock_WriteReq(uint32* destShramAddr,void* sourceAddr, uint32 sizeInWords);
void ProtectedDbLock_CopyReq(uint32* destShramAddr,void* sourceAddr, uint32 sizeInWords);
void ProtectedDbLock_ReadModifyWriteReq(uint32* destinationShramAddress, uint32 sizeInwords, 
										uint32* scratchPadAddress,ProtectedDbLock_localModificationFunc modificationFunc, void* pModificationFuncParams);

#endif /* PROTECTED_DB_LOCK_API_H_ */



