/***********************************************************************************
 File:			QueueUtility_Api.h
 Module:			Queue Utility
 Purpose: 		
 Description:		
 This module is the 
************************************************************************************/
#ifndef QUEUE_UTILITY_API_H_
#define QUEUE_UTILITY_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
typedef struct GeneralQueueBlock
{
	void * volatile head;
	void * volatile tail;
	uint16 numOfElements;
} GeneralQueueBlock_t;


typedef struct GeneralQueueItem GeneralQueueItem_t;

struct GeneralQueueItem
{
	GeneralQueueItem_t *nextQueueItem;
};

/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
void GeneralQ_PushItemToTail(GeneralQueueBlock_t *pQueueBlock, GeneralQueueItem_t *pQueueItem);
GeneralQueueItem_t *GeneralQ_PopItemFromHead(GeneralQueueBlock_t *pQueueBlock);
void GeneralQ_RemoveItem(GeneralQueueBlock_t *pQueueBlock, GeneralQueueItem_t *pQueueItem);
void GeneralQ_InitQueueBlock(GeneralQueueBlock_t *pQueueBlock);

#endif //QUEUE_UTILITY_API_H_



