/* CMSynergyVer %full_filespec: queue_utility.h;6.1.2.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET MAC: Queue Utility
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/queue_utility.h $
 **
 ** VERSION:        $Revision: #2 $
 **
 ** DATED:          $Date: 2004/01/30 $
 **
 ** AUTHOR:         IFO
 **
 ** DESCRIPTION:    General queue handling utilities.
 **
 ** LAST MODIFIED BY:   $Author: prh $
 **                     $Modtime:   $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom
 *
 ****************************************************************************/

#ifndef QUEUE_UTILITY_INCLUDED
#define QUEUE_UTILITY_INCLUDED

#include "OSAL_Kmsg.h"
#include "queue_priorities.h"
#if defined (ENET_INC_ARCH_WAVE600)
#define DEBUG_KERNEL_ACC
#endif

/* Forward reference to allow pointer in UMQ. struct definition follows later */
typedef struct UMQ_MSG UMQ_MSG;

typedef struct UMQ_Tag
{
    UMQ_MSG *psNextMsg;         /* Pointer to next message in the Queue (UMQ *)                 */
	UMQ_MSG *psNextTsMsg;	    /* Pointer to next message in the Queue (UMQ *)                 */
    uint32 u32MsgIdentifier;    /* Message identifier (to allow search)                         */
    uint8  u8MsgType;           /* Structure resource type (UM_PACKET_TYPE) - see above         */
    uint8  u8MsgState;          /* Message state - valid values vary depending on message type  */
    uint8  u8Result;            /* Result - used for passing a result code                      */
    uint8  u8ReturnTaskId;      /* Task which originated this message (used for callback)       */
} UMQ;


typedef struct _FunctionEntry_t
{
	void (* psTaskEventAction)(K_MSG *psMsg);
#if defined (DEBUG_KERNEL_ACC)
	K_MSG_TYPE  kmsgType;
#endif
} FunctionEntry_t;


#if defined (DEBUG_KERNEL_ACC)
#define DOUBLE_CHECK_MSG_TYPE(x)  x,
#define DOUBLE_CHECK_MSG_TYPE_HIM(x)  (x & 0xff),

#else
#define DOUBLE_CHECK_MSG_TYPE(x)
#define DOUBLE_CHECK_MSG_TYPE_HIM(x)
#endif

void vTaskDispatcher(K_MSG *pMsg, const FunctionEntry_t *pCurrTaskTable, uint16 firstIndex, uint16 lastIndex);

#endif /* QUEUE_UTILITY_INCLUDED */

