/***********************************************************************************
 File:			GeneralQ.c
 Module:			
 Purpose: 		General queue handling utility
 Description:		General queue handling utilities

************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "QueueUtility_Api.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_QUEUE_MGMT
#define LOG_LOCAL_FID 1


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/							Static Variables									
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/							Debug									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************
Description:
------------
	Put an item on the tail end of the queue
Input:
-----
	pQueueBlock -	Queue to add item into.
	QueueItem_t -	Item to add to queue end

Returns:
--------
	Void
**********************************************************************************/
void GeneralQ_PushItemToTail(GeneralQueueBlock_t *pQueueBlock, GeneralQueueItem_t *pQueueItem)
{
	TX_INTERRUPT_SAVE_AREA;
		
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	/* Check  queue isn't empty */
	if( pQueueBlock->head != NULL)
	{
		/* Sanity Check - Verify that queue item won't be linked to himself*/
		DEBUG_ASSERT( pQueueItem != (GeneralQueueItem_t *)pQueueBlock->tail);
		/* Place item at the tail of the queue */
		pQueueItem->nextQueueItem = NULL;
		((GeneralQueueItem_t *)(pQueueBlock->tail))->nextQueueItem = pQueueItem;
		pQueueBlock->tail = (void *)pQueueItem;
	}
	else
	{
		/* queue is empty */
		pQueueBlock->head = (void *)pQueueItem;
		pQueueItem->nextQueueItem = NULL;
		pQueueBlock->tail = (void *)pQueueItem;
	}
	
	pQueueBlock->numOfElements++;

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}


/**********************************************************************************


Description:
------------
	Put an item on the tail end of the queue
Input:
-----
	pQueueBlock -	Queue to add item into.
	QueueItem_t -	Item to add to queue end

Returns:
--------
	Void
**********************************************************************************/
GeneralQueueItem_t *GeneralQ_PopItemFromHead(GeneralQueueBlock_t *pQueueBlock)
{
	GeneralQueueItem_t *pQueuedItem; 
	TX_INTERRUPT_SAVE_AREA;
		
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
			
	 pQueuedItem = (GeneralQueueItem_t *)(pQueueBlock->head);

	/* Check for queu empty - if it is then no searching is required */
	if(pQueuedItem != NULL )
	{
		/* move head onto next so removing this item from the queue */
		pQueueBlock->head = (void *)pQueuedItem->nextQueueItem;
		/* check if queue is now empty */
		if( pQueueBlock->head == NULL )
		{
			/* queue is empty - tail should also point to NULL */
			pQueueBlock->tail = NULL;
		}
		pQueueBlock->numOfElements--;
	}

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
	
    return pQueuedItem;
}


void GeneralQ_RemoveItem(GeneralQueueBlock_t *pQueueBlock, GeneralQueueItem_t *pQueueItem)
{
	UNUSED_PARAM(pQueueBlock);
	UNUSED_PARAM(pQueueItem);	
}

/****************************************************************************
 **
 ** NAME:           GeneralQ_InitQueueBlock
 **
 ** PARAMETERS:     psQueue - Queue to init
 **
 ** RETURN VALUES:  none.
 **
 ** DESCRIPTION:    Initialise a queue.
 **
 ****************************************************************************/
 void GeneralQ_InitQueueBlock(GeneralQueueBlock_t *pQueueBlock)
{
	/* clear in queue */
	pQueueBlock->head = NULL;
	pQueueBlock->tail = NULL;
	pQueueBlock->numOfElements = 0;
}



