
/***********************************************************************************
 File:		queue_utility.c
 Module:		queue utility
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "QueueUtility_Api.h"
#include "queue_utility.h"
#include "ErrorHandler_Api.h"
#include "Pac_Api.h"
#include "loggerAPI.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "ShramErrorHandler.h"
#endif

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define LOG_LOCAL_GID   GLOBAL_GID_QUEUE_MGMT
#define LOG_LOCAL_FID 	2



/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

#if defined (DEBUG_KERNEL_ACC)
typedef struct _AAA_DebugKernelAccStruct1_t
{
	uint32 tsf;
	uint32 task;
	uint32 msg;
} AAA_DebugKernelAccStruct1_t;

AAA_DebugKernelAccStruct1_t AAA_DebugKernelAccArray1[128];
uint32 AAA_DebugKernelAccIdx1;
#endif


/*---------------------------------------------------------------------------------
/						Functions Definitions									
/----------------------------------------------------------------------------------*/


void vTaskDispatcher(K_MSG *pMsg, const FunctionEntry_t *pCurrTaskTable, uint16 firstIndex, uint16 lastIndex)
{
	K_MSG_TYPE  kmsgType = pMsg->header.tKMsgType;
	uint16 index = kmsgType - firstIndex;
	

#if defined (DEBUG_KERNEL_ACC)
{
	TX_INTERRUPT_SAVE_AREA;
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
#ifdef ENET_INC_ARCH_WAVE600
#ifdef ENET_INC_UMAC
	lastKmsgUM.header.tKMsgType = pMsg->header.tKMsgType;
	lastKmsgUM.header.vapId = pMsg->header.vapId;
#endif
#ifdef ENET_INC_LMAC0
	lastKmsgLM0.header.tKMsgType = pMsg->header.tKMsgType;
	lastKmsgLM0.header.vapId = pMsg->header.vapId;
#endif
#ifdef ENET_INC_LMAC1
	lastKmsgLM1.header.tKMsgType = pMsg->header.tKMsgType;
	lastKmsgLM1.header.vapId = pMsg->header.vapId;
#endif	
#endif
	AAA_DebugKernelAccArray1[AAA_DebugKernelAccIdx1].tsf = GET_TSF_TIMER_LOW();
	AAA_DebugKernelAccArray1[AAA_DebugKernelAccIdx1].task = (uint32)(pMsg->header.sTo.taskID);
	AAA_DebugKernelAccArray1[AAA_DebugKernelAccIdx1].msg = (uint32)(kmsgType);
	AAA_DebugKernelAccIdx1++;
    
	if(AAA_DebugKernelAccIdx1 == 128)
		AAA_DebugKernelAccIdx1 = 0;

	OSAL_ENABLE_INTERRUPTS(interrupt_save);

	ASSERT(kmsgType == pCurrTaskTable[index].kmsgType);
}
#endif //DEBUG_KERNEL_ACC

	// check that MsgType is legal in this task
	DEBUG_ASSERT((kmsgType >= firstIndex) && (kmsgType < lastIndex));

	LOGGER_API_LOG_KERNEL_EVENT(KERNEL_EVENT_RECV_KNL_MSG, pMsg);

	// Activate the function according to index (use function pointer)
	pCurrTaskTable[index].psTaskEventAction(pMsg);
}



