/* CMSynergyVer %full_filespec: ccmp.h;2:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - RSN 802.11i
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/rsn/ccmp.h $
 **
 ** DESCRIPTION:    Fundamental CCMP definitions and types
 **
 ** AUTHOR:         Ross Hetherington
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************
 **
 ** Copyright (c) 2003 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef __CCMP_H
#define __CCMP_H

/***************************************************************************/
/***                     Include File Dependencies                       ***/
/***************************************************************************/
#include "ieee80211.h"

/***************************************************************************/
/***                           Public Defines                            ***/
/***************************************************************************/

/* CCMP Header */
typedef struct CCMP_HEADER
{
    uint8 u8PN0;
    uint8 u8PN1;
    uint8 u8Rsvd;
    uint8 u8KeyID;
    uint8 u8PN2;
    uint8 u8PN3;
    uint8 u8PN4;
    uint8 u8PN5;
} CCMP_HEADER;

#define CCMP_HEADER_LENGTH                      (8)
#define CCMP_HEADER_RSVD_MANDATORY_VALUE        (0)
#define CCMP_HEADER_KEY_ID_EIV_FLAG             (1 << 5)
#define CCMP_HEADER_KEY_ID_INDEX(index)         (((index) & 0x03) << 6)                    

/* CCMP AAD Additional Authentication Data */
#define CCMP_AAD_MAX_LENGTH                     (30)
#define CCMP_AAD_A2_OFFSET                      (8)

/* CCMP MIC */
#define CCMP_MIC_LENGTH                         (8)

/* Key defines */
#define CCMP_TK_SIZE  (16)  /* CCMP uses the first 128bits of TK1 */

#define CCMP_MODE_KEY_ID_SHIFT					(6)
#define CCMP_MODE_KEY_ID_MASK					(0x3)


/***************************************************************************/
/***                           Public Functions                          ***/
/***************************************************************************/

#endif

