/* CMSynergyVer %full_filespec: encryptor.c;5.1.5.1.11.1.1.3.3:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - RSN 802.11i
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/rsn/encryptor.c $
 **
 ** DESCRIPTION:    Operations on Encryptor objects.  Each
 **                 station association has an encryptor for performing
 **                 encryption and decryption.  An encryptor will use
 **                 a specilialised Cipher Suite, depending on the suite
 **                 specified by the higher layers.  The Encryptor is
 **                 responsible for sequencing MSDUs and MPDUs for
 **                 hardware encryption and decryption.
 **
 ** AUTHOR:         Julian Hall
 **
 ** THIS VERSION:   $Revision: #5 $
 **   CHANGED ON:   $Date: 2004/02/17 $
 **           BY:   $Author: prh $
 **
 ****************************************************************************
 **
 ** Copyright (c) 2003 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

/***************************************************************************/
/***                        Include Files                                ***/
/***************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"
#include "OSAL_Api.h"
#include "rsn.h"
#include "encryptor.h"
#include "queue_utility.h"
#include "database.h"
#include "ccmp.h"
#include "stringLibApi.h"
#include "protocol.h"
#include "ErrorHandler_Api.h"
#include "Debug_Trace.h"
#include "Pac_Api.h"
#include "CpuLoad_Api.h"
#include "secManager_StaManager.h"
#include "secManager_VapManager.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_SECURITY
#define LOG_LOCAL_FID 0


/***************************************************************************/
/***                        Private Defines                              ***/
/***************************************************************************/

/***************************************************************************/
/***                      Private Function Prototypes                    ***/
/***************************************************************************/

/***************************************************************************/
/***                        Private static Data                          ***/
/***************************************************************************/

/***************************************************************************/
/***                    Macro operations on static data                  ***/
/***************************************************************************/

/* Table containing data about each management and control packet type */
static const FunctionEntry_t afpTaskTable[TASK_ENCRYPTION_END-TASK_ENCRYPTION_START]=
{
	{secManager_StaManagerAddSta,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_ADD_STA)},
	{secManager_StaManagerLockSta,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_LOCK_STA)},
	{secManager_StaManagerSetFilter,	DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_SET_FILTER)},
	{secManager_StaManagerSetKey,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_SET_KEY_STA)},
	{secManager_StaManagerSetIndex, 	DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_SET_STA_INDEX)},
	{secManager_StaManagerRemoveSta,	DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_REMOVE_STA)},
	{secManager_StaManagerLockGphp,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_LOCK_GPHP)},
	{secManager_VapManagerAddVap,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_ADD_VAP)},
	{secManager_VapManagerLockVap,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_LOCK_VAP)},
	{secManager_VapManagerSetKey,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_SET_KEY_VAP)},
	{secManager_VapManagerSetIndex,		DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_SET_VAP_INDEX)},
	{secManager_VapManagerRemoveVap,	DOUBLE_CHECK_MSG_TYPE(ENCRYPTION_REMOVE_VAP)},
};

/***************************************************************************/
/***                       Public Functions                              ***/
/***************************************************************************/

/****************************************************************************
 **
 ** NAME:           vENC_Task
 **
 ** PARAMETERS:     Kernel message
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    main entry point for task
 **
 ****************************************************************************/
void vENC_Task(K_MSG *psMsg)
{
    /* Use common task switching and Table */
	vTaskDispatcher(psMsg, afpTaskTable, TASK_ENCRYPTION_START, TASK_ENCRYPTION_END);
}

void vENC_Init(void)
		/*Nothing to do if we are moving from TKIP*/
		/*If we are moving to CCMP*/
			// Clear entries
		/*If we are moving to WEP*/
		/*Nothing to do if we are moving to TKIP*/

{
	secManager_StaManagerInit();
	secManager_VapManagerInit();

	/*Check and handle encryption type cnnage*/
	
}


