/***********************************************************************************
 File:			SecManager.h
 Module:		Sec Manager 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef SEC_MANAGER_STA_MANAGER_H_
#define SEC_MANAGER_STA_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//#define SEC_MANAGER_STA_MANAGER_FLUSH_ON_SET_KEY_OPTION	(1)

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
/*SEC Manager STA Manager states*/
typedef enum
{
	SEC_MANAGER_STA_MANAGER_CLOSED,
#if defined (SEC_MANAGER_STA_MANAGER_FLUSH_ON_SET_KEY_OPTION)		
	SEC_MANAGER_STA_MANAGER_WAIT_LOCK,
#endif
	SEC_MANAGER_STA_MANAGER_WAIT_FILTER,
	SEC_MANAGER_STA_MANAGER_OPEN,
	SEC_MANAGER_STA_MANAGER_REKEY,
	SEC_MANAGER_STA_MANAGER_NUM_STATES
} secManagerStaManager_state;

typedef struct SecManagerStaDb_s
{
	K_MSG						*pMsg;
	uint8						flags;
	StaId						sid;
	secManagerStaManager_state 	state;
	uint8						vapId;
} SecManagerStaDb_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern SecManagerStaDb_t SecManager_StaManagerDb[HW_NUM_OF_STATIONS];

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void secManager_StaManagerAddSta(K_MSG* secManagerMessage);
extern void secManager_StaManagerLockSta(K_MSG* secManagerMessage);
extern void secManager_StaManagerSetFilter(K_MSG* secManagerMessage);
extern void secManager_StaManagerSetKey(K_MSG* secManagerMessage);
extern void secManager_StaManagerSetIndex(K_MSG* secManagerMessage);
extern void secManager_StaManagerRemoveSta(K_MSG* secManagerMessage);
extern void secManager_StaManagerLockGphp(K_MSG* secManagerMessage);
extern void secManager_StaManagerInit(void);

#endif /* SEC_MANAGER_STA_MANAGER_H_ */



