/***********************************************************************************
 File:			SecManager.h
 Module:		Sec Manager 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef SEC_MANAGER_VAP_MANAGER_H_
#define SEC_MANAGER_VAP_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
/*SEC Manager VAP Manager states*/
typedef enum
{
	SEC_MANAGER_VAP_MANAGER_IDLE,
	SEC_MANAGER_VAP_MANAGER_WAIT_LOCK,
	SEC_MANAGER_VAP_MANAGER_ACTIVE,
	SEC_MANAGER_VAP_MANAGER_NUM_STATES
} secManagerVapManager_state;

typedef struct SecManagerVapDb_s
{
	K_MSG						*pMsg;
	uint8					   	vapId;
	uint8						cipherSuite;
	secManagerVapManager_state 	state;
} SecManagerVapDb_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern SecManagerVapDb_t SecManager_VapManagerDb[HW_NUM_OF_VAPS];

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern uint8 secManager_VapManagerGetCipherSuite(uint8 vapId);
extern void secManager_VapManagerAddVap(K_MSG* secManagerMessage);
extern void secManager_VapManagerLockVap(K_MSG* secManagerMessage);
extern void secManager_VapManagerSetKey(K_MSG* secManagerMessage);
extern void secManager_VapManagerSetIndex(K_MSG* secManagerMessage);
extern void secManager_VapManagerRemoveVap(K_MSG* secManagerMessage);
extern void secManager_VapManagerInit(void);

#endif /* SEC_MANAGER_VAP_MANAGER_H_ */




