/* CMSynergyVer %full_filespec: tkip.h;2:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - RSN 802.11i
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/rsn/tkip.h $
 **
 ** DESCRIPTION:    Fundamental TKIP definitions and types
 **
 ** AUTHOR:         Ross Hetherington
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************
 **
 ** Copyright (c) 2003 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef __TKIP_H
#define __TKIP_H

#define MAX_TKIP_DEC_PACKET_SIZE (2 * 1024)

/* *************** */
/* Frame structure */
/* *************** */
#define TKIP_MODE_IV_EIV_LENGTH             (8)
#define TKIP_MODE_ICV_LENGTH                (4)
#define TKIP_MODE_MIC_LENGTH                (8)
#define TKIP_MODE_KEY_LENGTH                (16)
#define TKIP_MODE_PHASE_ONE_KEY_SIZE        (10)

typedef struct TKIP_IV_EIV
{
    uint8 u8IVbyte1;
    uint8 u8IVbyte2;
    uint8 u8IVbyte3;
    uint8 u8KeyID;
    uint8 u8EIVbyte1;
    uint8 u8EIVbyte2;
    uint8 u8EIVbyte3;
    uint8 u8EIVbyte4;
} TKIP_IV_EIV;


/* Bits in u8KeyID */
#define TKIP_MODE_KEY_ID_EIV_FLAG     (0x20)    /* bit 5 */

#define TKIP_MODE_KEY_ID_SHIFT        (6)
#define TKIP_MODE_KEY_ID_MASK         (0x3)     /* bits 6 & 7 */

typedef uint8 TKIP_MIC[TKIP_MODE_MIC_LENGTH];

/* *************** */
/*      keys       */
/* *************** */

#define TKIP_TK1_SIZE  (16)  /* TKIP uses the first 128bits of TK1 */
#define TKIP_TK2_SIZE  (16)  /* TKIP used the first 128bits of TK2 */

#define TKIP_NUM_OF_KEYS	(2) /*We need to support two simultanous keys, specially for MCAST RX in STA mode*/

#endif

