/***************************************************************
 File:		   ShramBaAnalyzerFifos.h
 Module:	   Shram
 Purpose: 	   holds the declerations of the BA analyzer status FIFO
 Description:  This file contains the declerations of the BA 
 			   analyzer status FIFO
***************************************************************/
#ifndef SHRAM_BA_ANALYZER_STATUS_FIFO_H_
#define SHRAM_BA_ANALYZER_STATUS_FIFO_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "BaAnalyzer.h"


#if defined (ENET_INC_ARCH_WAVE600)
#include "BaaTxStatusFifo_Descriptors.h"
#include "BaaRateAdaptiveCommonFifo_Descriptors.h"
#include "BaaRateAdaptiveUserFifo_Descriptors.h"
#endif

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define BA_ANALYZER_MAC_STATUS_FIFO_SIZE 16
 

/* The size needs to be of 2^n */
#define BA_ANALYZER_UMAC_STATUS_FIFO_SIZE_MASK (BA_ANALYZER_MAC_STATUS_FIFO_SIZE - 1)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

typedef enum
{
	BA_ANALYZER_RESPONSE_TYPE_NONE_ACKABLE 		     = 0,
	BA_ANALYZER_RESPONSE_TYPE_ALL_MPDUS_SUCCEEDED    = 1,
    BA_ANALYZER_RESPONSE_TYPE_ALL_MPDUS_FAILED 		 = 2,
    BA_ANALYZER_RESPONSE_TYPE_SOME_MPDUS_FAILED 	 = 3,
    BA_ANALYZER_RESPONSE_TYPE_ACK_RECEIVED		     = 4,
    BA_ANALYZER_RESPONSE_TYPE_TIMEOUT    		     = 8,
    BA_ANALYZER_RESPONSE_TYPE_OTHER_RX    		     = 9,
    BA_ANALYZER_NUM_OF_RESPONSE_TYPE,
	BA_ANALYZER_MAX_NUM_OF_RESPONSE_TYPE             = MAX_UINT8
}BaAnalyzerResponseType_e;


typedef struct BaAnalyzerStatus
{
	/* word 0 */
	uint32 txQueueTid		:3;
	uint32 txQueueStationId :8;
	uint32 txQueueVapId 	:4;
	uint32 txQueueGroup 	:3;
	uint32 reserved  	    :6;
	uint32 pdType           :4;
	uint32 responseType     :4;

	/* word 1 */
	uint32 headPd           :16;
	uint32 tailPd           :16;
	
	/* word 2 */
	uint32 barControl          :16;
	uint32 SequenceControl_t   :16;

	/* word 3 - 4  */
	uint32 bitmap[2];

	/* word 5 */
	uint32 genriscReserved1;

	/* word 6 */
	uint32 genriscReserved2;
}BaAnalyzerStatus_t;

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
#ifndef ENET_INC_ARCH_WAVE600
extern BaAnalyzerStatus_t BaAnalyzerStatusFifo[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; 
#else

extern BaaTxStatusFifo_t BaAnalyzerStatusFifo[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; 
extern BaaTxStatusFifo_t BaAnalyzerStatusFifo_B1[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; 

#endif

#ifndef ENET_INC_ARCH_WAVE600
extern BaaRateAdaptiveFifo_t baaFifoReport[MAX_TX_BAA_FIFO_SIZE];
#else

extern BaaRateAdaptiveCommonFifo_t BaAnalyzerRaCommonReportFifo[BAA_COMMON_FIFO_SIZE];
extern BaaRateAdaptiveUserFifo_t BaAnalyzerRaUserReportFifo[BAA_USER_FIFO_SIZE];

extern BaaRateAdaptiveCommonFifo_t BaAnalyzerRaCommonReportFifo_B1[BAA_COMMON_FIFO_SIZE];
extern BaaRateAdaptiveUserFifo_t BaAnalyzerRaUserReportFifo_B1[BAA_USER_FIFO_SIZE];

#endif

#endif

