/***************************************************************
 File:		ShramRxfFifo.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of Rxf fifo.
 			Fifo line indicates recive of an A-MPDU frame with no BA agreement open.
 Description:  This file contains the allocation of the RXF fifo block
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#ifdef ENET_INC_ARCH_WAVE600D2
#include "MbfmErrFifo_Descriptors.h"
#endif
#include "ShramRxfFifo.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define BEAMFORMING_FEEDBACK_LENGTH (499) /* 0x1F3*/

#ifdef ENET_INC_ARCH_WAVE600
#define HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE		(15) // 16 entries in the Error FIFO
#endif
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef struct BeamFormingDatabase
{
	uint8 reportLength:8;
	uint8 reportLength1:8;
	uint16 minmoCtrl;
	uint8 snr0;
	uint8 snr1;
	uint8 snr2;
	uint8 snr3;
	uint8 beamformingFeedback[BEAMFORMING_FEEDBACK_LENGTH];	
 	StaId staIndex;
 	uint16 reportlengthTransmittedByDelia;
	uint16 tsf;
} BeamFormingDatabase_t;


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
#ifdef ENET_INC_ARCH_WAVE600D2
	MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO")
	extern MbfmErrFifo_t  BeamformingErrorFifo[(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; 
	MAP_TO_DEFAULT_SECTION(bss)
	MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO_B1")
	extern MbfmErrFifo_t BeamformingErrorFifo_B1[(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)];
	MAP_TO_DEFAULT_SECTION(bss)
#else //ENET_INC_ARCH_WAVE600D2
#ifdef ENET_INC_ARCH_WAVE600
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO")
extern uint32  BeamformingErrorFifo[2*(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; // Each entry is 2 words (8 bytes)
MAP_TO_DEFAULT_SECTION(bss)
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO_B1")
extern uint32  BeamformingErrorFifo_B1[2*(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; // Each entry is 2 words (8 bytes)
MAP_TO_DEFAULT_SECTION(bss)
#else
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING")
extern BeamFormingDatabase_t BeamformingDatabase[HW_NUM_OF_STATIONS + 1];
extern uint8 BeamformingIndexesTable[HW_NUM_OF_STATIONS];
MAP_TO_DEFAULT_SECTION(bss)
#endif //ENET_INC_ARCH_WAVE600
#endif //ENET_INC_ARCH_WAVE600D2


