/***************************************************************
 File:		ShramDeliaDescriptors.h
 Module:	Shram
 Purpose: 	holds the declerations the Delia descriptors 
 Description:  This file contains the declerations of the Delia descriptors
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_DELIA_DESCRIPTORS_H_
#define SHRAM_DELIA_DESCRIPTORS_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "Deliad_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
#ifdef ENET_INC_ARCH_WAVE600

extern Deliad_t DeliaDataStructure;
extern Deliad_t DeliaDataStructure_B1;

#else

#define DELIA_DESCRIPTOR_SIZE 3
#define DELIA_MAX_DESCRIPTORS 64
#define DELIA_COMMOM_DESCRIPTOR_SIZE 7

extern uint32 DeliaDescriptors[4][DELIA_COMMOM_DESCRIPTOR_SIZE + (DELIA_DESCRIPTOR_SIZE * DELIA_MAX_DESCRIPTORS)];

#endif //ENET_INC_ARCH_WAVE600

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------



#endif /*SHRAM_DELIA_DESCRIPTORS_H_ */

