/***************************************************************
 File:		ShramDmacWrapper.h
 Module:	  	Shram
 Purpose: 	holds the buffers that contain the manipulation lists and the programs of the DMAC
 Description:   holds the buffers that contain the manipulation lists and the programs of the DMAC
***************************************************************/
#ifndef SHRAM_DMAC_WRAPPER_H_
#define SHRAM_DMAC_WRAPPER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ConfigurationManager_api.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


#define DMAC_WRAPPER_MANIPULATION_LISTS_DWORD_SIZE 64  // 0x40 (64Bytes) x 4(channels num) = 256 (0x100)

#ifdef ENET_INC_ARCH_WAVE600
#define DMAC_WRAPPER_CHANNEL_PROGRAMS_DWORD_SIZE   192
#else
#define DMAC_WRAPPER_CHANNEL_PROGRAMS_DWORD_SIZE   256 // 0x100 (256Bytes) x 4 (channels num) = 1024 (0x400)
#endif
#define DMAC_WRAPPER_JUNK_YARD_DWORD_SIZE   4 


//---------------------------------------------------------------------------------
//							Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _dmaWrapperDb_t_
{
	uint32 ManipListsShramBuffer[DMAC_WRAPPER_MANIPULATION_LISTS_DWORD_SIZE];
	uint32 ChannelProgramsShramBuffer[DMAC_WRAPPER_CHANNEL_PROGRAMS_DWORD_SIZE];
	uint32 JunkYard[DMAC_WRAPPER_JUNK_YARD_DWORD_SIZE];
	uint32 reserved[4]; // this reserved is in order to make the next instance (band1 if exist) to be also 32 bytes aligned
} dmaWrapperDb_t;


//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------


#ifdef ENET_INC_ARCH_WAVE600
// In Gen6 we have 2 instances (per band)
extern dmaWrapperDb_t DmaWrapperDb[NUM_OF_CONFIGURATION_MANAGER_BANDS];
#else
#pragma alignvar (8)
// In gen5 we have only 1 instance
extern dmaWrapperDb_t DmaWrapperDb;
#pragma alignvar (4)

#endif


#endif /* SHRAM_DMAC_WRAPPER_H_ */

