/***************************************************************
 File:		ShramErrorHand.h
 Module:	  	Shram
 Purpose: 	Allocation of required Error Handler variables on Shram
 Description:  holds the allocation in memory of the error handler related variables 
***************************************************************/
#ifndef SHRAM_ERROR_HANDLER_H_
#define SHRAM_ERROR_HANDLER_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "shram.h"
#include "System_Information.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "OSAL_Kmsg.h"
#endif
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
// Note: when changing this struct size, make sure to change also SHARED_RAM_WATCHDOG_SIZE on the .ld file
// current:
// SHARED_RAM_WATCHDOG_SIZE 0x2C

typedef struct ErrorHandleEventDetails
{  
	uint16	  uCoreNum;	 
	uint16	  uMagicMun;
	uint32	  uTimeStamp;
	uint32	  uCauseRegOrLineNum;
	uint32	  uStatusReg;
	uint32	  uEpcReg;
	uint16	  uFileId;
	uint16	  uGroupId;
	uint16	  uOriginId;
	uint16	  uFWinterface;
	uint32	  uSpReg;
} ErrorHandleEventDetails_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
MAP_TO_SECTION(bss, ".SHARED_RAM_ERROR_HANDLER")
extern 	FW_CORE_CONTROL_DESCRIPTOR u32FwCoreControlDesc;
extern 	ErrorHandleEventDetails_t  ErrorHandler_EventDetails[MAX_NUM_OF_FW_CORES];
extern  uint32 FWinterface; /* Logmacros Uses thid variable*/
extern  CoreNum_e errorHandlerTriggerCore;
extern 	bool	ErrorHandlerLm0InAssert ; 
#ifdef ENET_INC_ARCH_WAVE600
extern 	bool	ErrorHandlerLm1InAssert ; 
extern K_MSG	lastKmsgUM;
extern K_MSG	lastKmsgLM0;
extern K_MSG	lastKmsgLM1;

#endif
MAP_TO_DEFAULT_SECTION(bss)

#endif /* SHRAM_ERROR_HANDLER_H_ */

