/***************************************************************
 File:		ShramGenRiscMailboxes.h
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the Tx sender, Rx Hanldler and Host interface - FW interface structures 
 Description:  This file contains the allocation of the Tx sender, Rx Hanldler and Host interface - FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "TxSender_MailboxApi.h"
#include "RxHandler_MailboxApi.h"
#include "HostInterface_MailboxApi.h"




/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_RX_HANDLER_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES			(0x2)
#define FW_GENRISC_RX_HANDLER_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES		(0x2)
#else // not wave600
#define FW_GENRISC_RX_HANDLER_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES		(0x1)
#define FW_GENRISC_RX_HANDLER_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES		(0x1)
#define FW_GENRISC_RX_HANDLER_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES		(0x1)
#define FW_GENRISC_RX_HANDLER_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES		(0x1)
#endif

#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_TX_SENDER_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES   		(0x1)
#define FW_GENRISC_TX_SENDER_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES  		(0x1)
#else
#define FW_GENRISC_TX_SENDER_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES  	 	(0x1)
#define FW_GENRISC_TX_SENDER_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES  		(0x1)
#define FW_GENRISC_TX_SENDER_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES   		(0x1)
#define FW_GENRISC_TX_SENDER_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES 		(0x1)
#endif //ENET_INC_ARCH_WAVE600


#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES   	(0x1)
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES  	(0x1)
#else
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES	(0x1)
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES	(0x1)
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES	(0x1)
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES	(0x1)
#endif //ENET_INC_ARCH_WAVE600


#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_RX_HANDLER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailboxFifoInMessage_t) >> 0x2))
#define FW_GENRISC_RX_HANDLER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailboxFifoOutMessage_t) >> 0x2))
#else
#define FW_GENRISC_RX_HANDLER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailbox0FifoInMessage_t) >> 0x2))
#define FW_GENRISC_RX_HANDLER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS	(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailbox0FifoOutMessage_t) >> 0x2))
#define FW_GENRISC_RX_HANDLER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailbox1FifoInMessage_t) >> 0x2))
#define FW_GENRISC_RX_HANDLER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS	(0x2 + FW_GENRISC_RX_HANDLER_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwRxHandlerMailbox1FifoOutMessage_t) >> 0x2))
#endif

#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_TX_SENDER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailboxFifoInMessage_t) >> 0x2))
#define FW_GENRISC_TX_SENDER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailboxFifoOutMessage_t) >> 0x2))
#else
#define FW_GENRISC_TX_SENDER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailbox0FifoInMessage_t) >> 0x2))
#define FW_GENRISC_TX_SENDER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailbox0FifoOutMessage_t) >> 0x2))
#define FW_GENRISC_TX_SENDER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailbox1FifoInMessage_t) >> 0x2))
#define FW_GENRISC_TX_SENDER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS		(0x2 + FW_GENRISC_TX_SENDER_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwTxSenderMailbox1FifoOutMessage_t) >> 0x2))
#endif //ENET_INC_ARCH_WAVE600

#ifdef ENET_INC_ARCH_WAVE600
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_BUFFER_SIZE_IN_WORDS	(0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailboxFifoInMessage_t) >> 0x2))
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS	(0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailboxFifoInMessage_t) >> 0x2))
#else
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS	 (0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailbox0FifoInMessage_t) >> 0x2))
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS (0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailbox0FifoOutMessage_t) >> 0x2))
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS	 (0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailbox1FifoInMessage_t) >> 0x2))
#define FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS (0x2 + FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES * (sizeof(FwHostGenRiscInterfaceMailbox1FifoOutMessage_t) >> 0x2))
#endif //ENET_INC_ARCH_WAVE600



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600

// Mailboxes for band 0
extern uint32 FwRxHandlerMailboxFifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwRxHandlerMailboxFifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

extern uint32 FwTxSenderMailboxFifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwTxSenderMailboxFifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

// Mailboxes for band 1
extern uint32 FwRxHandlerMailboxFifoInBuffer_B1[FW_GENRISC_RX_HANDLER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwRxHandlerMailboxFifoOutBuffer_B1[FW_GENRISC_RX_HANDLER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

extern uint32 FwTxSenderMailboxFifoInBuffer_B1[FW_GENRISC_TX_SENDER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwTxSenderMailboxFifoOutBuffer_B1[FW_GENRISC_TX_SENDER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

extern uint32 FwHostGenRiscInterfaceMailboxFifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwHostGenRiscInterfaceMailboxFifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];


#else // not wave600

#ifdef FW_RX_HANDLER_MAILBOX_0_ENABLED
extern uint32 FwRxHandlerMailbox0FifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwRxHandlerMailbox0FifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_RX_HANDLER_MAILBOX_1_ENABLED
extern uint32 FwRxHandlerMailbox1FifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwRxHandlerMailbox1FifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_TX_SENDER_MAILBOX_0_ENABLED
extern uint32 FwTxSenderMailbox0FifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwTxSenderMailbox0FifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_TX_SENDER_MAILBOX_1_ENABLED
extern uint32 FwTxSenderMailbox1FifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwTxSenderMailbox1FifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
extern uint32 FwHostGenRiscInterfaceMailbox0FifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwHostGenRiscInterfaceMailbox0FifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
extern uint32 FwHostGenRiscInterfaceMailbox1FifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
extern uint32 FwHostGenRiscInterfaceMailbox1FifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#endif //ENET_INC_ARCH_WAVE600



