/***************************************************************
 File:		ShramHim.h
 Module:	  	Shram
 Purpose: 	holds the allocation in memory Him fifo's
 Description:  This file contains the shram allocation allocation of the  Host Interface 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mhi_umi_propr.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
/* Circulate buffers for transfer of info between host and card */
#define HIM_CIRCULAR_BUFFER_SIZE    (HIM_CHI_N+1)

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES_B1")
extern SHRAM_MAN_MSG asHIMmanReqSecured[NUM_MAN_REQS];
extern SHRAM_DBG_MSG asHIMdbgReqSecured[NUM_DBG_REQS];
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_DRIVER_INTERFACE")
/* Message pools used by the Host for Request messages. */
extern SHRAM_MAN_MSG asHIMmanReq[NUM_MAN_REQS];
extern SHRAM_BSS_REQ_MSG asHIMBssReq[NUM_BSS_REQS];
extern SHRAM_DBG_MSG asHIMdbgReq[NUM_DBG_REQS];
extern SHRAM_DBG_MSG asHIMdbgInd[NUM_DBG_INDS];

/* Buffer descriptor of dat ind */
extern RXDAT_IND_MSG_DESC asHIMdatIndDesc[NUM_DAT_INDS];

/* Buffer descriptor of BSS ind */
extern RX_BSS_IND_MSG_DESC asHIMBssIndDesc[NUM_BSS_INDS];

/* UMI BSS indications */
extern SHRAM_IND_MSG asMAN_IndData[NUM_MAN_INDS];  

/* Areas for message passing. */
extern uint32  au32FIFOReqResQ[HIM_CIRCULAR_BUFFER_SIZE];  /* Host to HIM queue */
extern uint32  au32FIFOCfmIndQ[HIM_CIRCULAR_BUFFER_SIZE];  /* HIM to Host queue */

/* logger indicate him og logger mode */
extern uint32  loggerActiveMode;

MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA
