/***************************************************************
 File:		ShramNewDeliaRecipes.h
 Module:	  	Shram
 Purpose: 	holds the declerations the new Delia recipes 
 Description:  This file contains the declerations of the new Delia recipes
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_NEW_DELIA_RECIPES_H_
#define SHRAM_NEW_DELIA_RECIPES_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "DeliaRecipes.h"
#else
#include "VapDb.h"
#endif //ENET_INC_ARCH_WAVE600
#if defined (ENET_INC_ARCH_WAVE600B)
#include "DeliaRecipes_Api.h"
#endif //ENET_INC_ARCH_WAVE600B


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define DELIA_RECIPE_LOOKUP_TABLE_SIZE 16


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES")

#if defined (ENET_INC_ARCH_WAVE600)

extern DeliaRecipes_t DeliaRecipes;
extern Tcr_t DeliaAutoResponseTcrs;
#if defined (ENET_INC_ARCH_WAVE600B)
extern SuTcrs_t MbfmTcrs; //this address must be word aligned - we get it now since all the structs above are word-aligned
#endif //ENET_INC_ARCH_WAVE600B
#else

extern uint32 DeliaRecipe0[];
extern uint32 DeliaRecipesLookupTable[];
extern uint32 DeliaRecipeAck[];
extern uint32 DeliaRecipeBa[];
extern uint32 DeliaRecipeCtsAutoResponse[];
extern uint32 DeliaRecipeBfReport[];
extern Tcr0_t DeliaAutoResponseTcr0;
extern Tcr2_t DeliaAutoResponseTcr2;
extern Tcr2_t DeliaAutoResponseCtsTcr2;

#endif //ENET_INC_ARCH_WAVE600

MAP_TO_DEFAULT_SECTION(bss)

#if defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES")
extern DeliaRecipes_t DeliaRecipes_B1;
extern Tcr_t DeliaAutoResponseTcrs_B1;
#if defined (ENET_INC_ARCH_WAVE600B)
extern SuTcrs_t MbfmTcrs_B1;
#endif //ENET_INC_ARCH_WAVE600B

MAP_TO_DEFAULT_SECTION(bss)
#endif



#endif /*SHRAM_NEW_DELIA_RECIPES_H_ */


