/***************************************************************
 File:		ShramPacketDescriptors.h
 Module:	  	Shram
 Purpose: 	holds the declerations the Packet descriptors 
 Description:  This file contains the declerations of the Packet descriptors
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_PACKET_DESCRIPTORS_H_
#define SHRAM_PACKET_DESCRIPTORS_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------


MAP_TO_SECTION(bss, ".SHARED_RAM_PACKET_DESCRIPTORS")

extern uint32* PacketDescriptorsPtr; 

MAP_TO_DEFAULT_SECTION(bss)



//#define GEN5_TX_DEBUG


#ifdef GEN5_TX_DEBUG

typedef struct DebugGen5
{
	uint8   isAgg;
	uint8   baOrNack;
	uint16  aggBuilderStopReason;
	uint32  txHandlerStart;
	uint32  aggbuilderStart;
	uint32  aggBuilderIsr;
	uint32  prgNrm;
	uint32  rcdBa;
	uint32  checkTxQ;
	uint32  numOfPackets;
	uint32  numOfNacked;
	uint32  numOfDiscard;
	uint32  headPdLength;
	uint32  aggAirTime;
	uint32 	aggTotalLength;
	uint32  Sn;

// DEBUG
	uint32  beaconInQ;
	uint32  preSelector;
	uint32  postSelector;

	
}DebugGen5_t;


#define NUM_DEBUG_ENTRIES 100

extern DebugGen5_t DebugGen5[NUM_DEBUG_ENTRIES];
extern uint8 DebugGen5Index;
#endif



#endif /*SHRAM_PACKET_DESCRIPTORS_H_ */

