/***************************************************************
 File:		ShramPhyStatDb.h
 Module:	  	Shram
 Purpose: 	holds the declerations of phy status DB
 Description:  This file contains the allocation of the phy status DB 
			 structure in the SHRAM
***************************************************************/
#ifndef SHRAM_PHY_STAT_H_
#define SHRAM_PHY_STAT_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "Statistics_Api.h"
#include "Statistics_Descriptors.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "RxHandler_PhyStatusApi.h"
#else
#include "PacExtrapolator_api.h"
#endif

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#ifdef ENET_INC_ARCH_WAVE600
#define PHY_STATUS_NUMBER_OF_WORDS (/*TSF*/0x1 + /*Matrices*/0x2 + /*Status*/0x6)
#endif // ENET_INC_ARCH_WAVE600

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
#ifdef CPU_MIPS
#pragma alignvar (4)
#endif
#if !defined (ENET_INC_ARCH_WAVE600)
extern uint32 phyMetricFifo[SIZE_OF_METRICS_FIFO*PHY_STATUS_NUMBER_OF_WORDS + 2/*read and write counters */];
#endif

extern wholePhyRxStatusDb_t phyRxStatusDb;
#if defined (ENET_INC_ARCH_WAVE600)
extern AlphaFilterStatistics_t 				pacExtrapolatorRssi;
extern pacExtrapolator_AlphaFactorWlan_t 	pacExtrapolatorAlphaFactorWlan;
extern pacExtrapolator_AlphaFactorSta_t 	pacExtrapolatorAlphaFactorSta;
extern pacExtrapolator_LnBetaValue_t 		pacExtrapolatorLnBetaValue;
#endif



#endif /*#ifndef SHRAM_PHY_STAT_H_ */

