/***************************************************************
 File:		ShramPlannerResources.h
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of MU Plan and phases.
 			
 Description:  This file contains the allocation of the MU plans and phases
***************************************************************/
#ifndef SHRAM_PLANNER_REOUSRCES_H_
#define SHRAM_PLANNER_REOUSRCES_H_


/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "CommonPlan_Descriptors.h"
#include "DlDataPhase_Descriptors.h"
#include "UlDataPhase_Descriptors.h"
#include "SoundingPhase_Descriptors.h"
#include "HeSoundingNdpaPointer_Descriptors.h"
#include "ProtectionPhase_Descriptors.h"
#include "PlanDbBaseAddr_Descriptors.h"
#include "HwMemoryMap.h"
#ifdef ENET_INC_ARCH_WAVE600D2
#include "NfrpPhase_Descriptors.h"
#endif


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/


#define	MAX_NUMBER_OF_PLANS					32

#ifdef ENET_INC_HW_FPGA
#define	MAX_NUMBER_OF_DATA_PHASES			32
#else
#define	MAX_NUMBER_OF_DATA_PHASES			64
#endif //ENET_INC_HW_FPGA

#define MAX_NUMBER_OF_DATA_PHASES_PER_BAND  32

#define	MAX_NUMBER_OF_SOUNDING_PHASES		MAX_NUMBER_OF_PLANS //Do not change - always depands on the MAX_NUMBER_OF_PLANS value 
#define	MAX_NUMBER_OF_PROTECTION_PHASES		MAX_NUMBER_OF_PLANS //Do not change - always depands on the MAX_NUMBER_OF_PLANS value 
#ifdef ENET_INC_ARCH_WAVE600D2
#define	MAX_NUMBER_OF_NFRP_PHASES			MAX_NUMBER_OF_PLANS //Do not change - always depands on the MAX_NUMBER_OF_PLANS value 
#endif

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

typedef struct _DataPhase_t
{
	union
	{
		DlDataPhase_t dlDataPhaseStructure;
		UlDataPhase_t ulDataPhaseStructure;

	};
} DataPhase_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".SHARED_RAM_HE_MU_PLAN_PHASE_ARRAY")
extern CommonPlan_t	heMuPlansArray[MAX_NUMBER_OF_PLANS];
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_HE_MU_PLAN_PHASE_ARRAY")
extern	DataPhase_t			heMuDataPhaseArray[MAX_NUMBER_OF_DATA_PHASES];
extern	SoundingPhase_t		heMuSoundingPhaseArray[MAX_NUMBER_OF_SOUNDING_PHASES];
extern	ProtectionPhase_t	heMuProtectionPhaseArray[MAX_NUMBER_OF_PROTECTION_PHASES];	
#ifdef ENET_INC_ARCH_WAVE600D2
extern  NfrpPhase_t			heMuNfrpPhaseArray[MAX_NUMBER_OF_NFRP_PHASES];
#endif

MAP_TO_DEFAULT_SECTION(bss)

// Struct used by the Sender and filled by FW used to define NDPA parameters in Sounding phase
MAP_TO_SECTION(bss, ".SHARED_RAM_HE_MU_SOUNDING_PHASE_STRUCT")
extern HeSoundingNdpaPointer_t heSoundingNdpaArray[MAX_NUMBER_OF_PLANS];
MAP_TO_DEFAULT_SECTION(bss)

// Look Up Table used by the Pre-Aggregator and filled by FW to map Plan Indexes to Plan pointers
MAP_TO_SECTION(bss, ".SHARED_RAM_PLAN_LUT_TRANSLATION")
extern PlanDbBaseAddrCommon_t heMuPlanLUT[MAX_NUMBER_OF_PLANS];
MAP_TO_DEFAULT_SECTION(bss)

// Descriptor RAM buffer for missing mem in fpga
MAP_TO_SECTION(bss, ".DESCRIPTOR_RAM_BUFFER_FOR_MISSING_MEM_IN_FPGA")
#ifdef ENET_INC_HW_FPGA
extern uint32 DescriptorRamBufferForMissingMemInFpga[(DESCRIPTOR_RAM_SIZE - REDUCED_DESCRIPTOR_RAM_SIZE) >> 0x2]; //SIZE OF DESC RAM in FPGA is only 0x00080000
#endif //ENET_INC_HW_FPGA
MAP_TO_DEFAULT_SECTION(bss)



#endif // SHRAM_PLANNER_REOUSRCES_H_

