/***************************************************************
 File:		ShramPsManager.h
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  sender - FW interface structures 
 Description:  This file contains the allocation of the  sender - FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramSecurity.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "PsSettingFifoShram_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#if !defined (ENET_INC_ARCH_WAVE600)
#define PS_MANAGER_STATUS_FIFO_SIZE		(16) /* Max Size Allowed = 256*/
#else
#define PS_MANAGER_STATUS_FIFO_SIZE		(64) /* Supporting 36 users, needs to be power of 2 */
#endif //!ENET_INC_ARCH_WAVE600

#define PS_MANAGER_STATUS_FIFO_SIZE_MASK  (PS_MANAGER_STATUS_FIFO_SIZE - 1)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
#if !defined (ENET_INC_ARCH_WAVE600)
typedef struct PsManagerStatusFifoEntry_s
{
	uint32 addr2Index:7;
	uint32 reserved1:1;
	uint32 setPsStatus:1;					// PS Status was set in TX Selector 	
	uint32 clearPsStatus:1;					// PS Status was reset in TX Seletcor
	uint32 noFreeNdpPd:1;						// NDP was supposed to be sent but PD is not available
	uint32 psPollWrongAid:1;				// Received PS-POLL with wrong AID
	uint32 psPollPowerManagementBitOff :1;	// Received PS-POLL with PM bit = 0
	uint32 reserved2:2;
	uint32 psduPsType:1;					// Power Save Type (0=Legacy / 1=WMM)
	uint32 reserved3 :16;
} PsManagerStatusFifoEntry_t;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
extern PsManagerStatusFifoEntry_t PsManagerStatusFifo[PS_MANAGER_STATUS_FIFO_SIZE];
#else
extern PsSettingFifoShram_t PsManagerStatusFifo[PS_MANAGER_STATUS_FIFO_SIZE];
extern PsSettingFifoShram_t PsManagerStatusFifo_B1[PS_MANAGER_STATUS_FIFO_SIZE];
#endif //ENET_INC_ARCH_WAVE600




