/***************************************************************
 File:		ShramRxDescriptors.h
 Module:	Shram
 Purpose: 	holds the declerations of the Rx descriptors pools sections
 Description:  This file contains the declerations of the Rx descriptors pools
 			   section in the SHRAM
***************************************************************/
#ifndef SHRAM_RX_DESCRIPTORS_H_
#define SHRAM_RX_DESCRIPTORS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxDescriptor.h"
#include "HwQManager_API.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define NUM_OF_FW_RX_DESCRIPTORS 							(100)
#if defined (ENET_INC_ARCH_WAVE600)
#ifndef ENET_INC_HW_FPGA
#define NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS 			(20480)
#else
#define NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS 			(1024)
#endif
#else
#define NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS 			(1024)
#endif

#define NUM_OF_FORWARD_RX_DESCRIPTORS 						(20)
#define NUM_OF_HOST_MANAGEMENT_RX_DESCRIPTORS 				(128)
#define NUM_OF_MANAGEMENT_RX_DESCRIPTORS 					(NUM_OF_HOST_MANAGEMENT_RX_DESCRIPTORS - NUM_OF_FORWARD_RX_DESCRIPTORS)

#define NUM_OF_HOST_RX_DESCRIPTORS 							(NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS + NUM_OF_HOST_MANAGEMENT_RX_DESCRIPTORS)

#define INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR				(0x0)
#define INDEX_OF_HOST_FIRST_RX_DESCRIPTOR					(INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR + NUM_OF_HOST_MANAGEMENT_RX_DESCRIPTORS)
#define INDEX_OF_FORWARD_FIRST_RX_DESCRIPTOR				(INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR + NUM_OF_MANAGEMENT_RX_DESCRIPTORS)
#define INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR	(INDEX_OF_HOST_FIRST_RX_DESCRIPTOR)


#define NUM_OF_DUMMY_RX_DESCRIPTORS 						(0x1)

#if defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600D2)
#define MAX_NUM_OF_HOST_FREE_LIST_POP_USERS					(0x3) // several entities could try to pop RD in parallel to each other: 2 rxh, Logger
#endif // defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600D2

//senity check
#if (INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR != (INDEX_OF_FORWARD_FIRST_RX_DESCRIPTOR + NUM_OF_FORWARD_RX_DESCRIPTORS))
#error "Host Data First RD descriptor index is not correct"
#endif

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
extern Rd_t  FwRxDescriptorsPool[NUM_OF_FW_RX_DESCRIPTORS];
extern Rd_t  HostRxDescriptorsPool[NUM_OF_HOST_RX_DESCRIPTORS];
extern Rd_t  DummyRxDescriptorsPool[NUM_OF_DUMMY_RX_DESCRIPTORS];

#if defined (ENET_INC_ARCH_WAVE600)
extern b0RxTxMpduDesc_u	B0_MpduDescriptors;
extern b1RxTxMpduDesc_u	B1_MpduDescriptors;
#ifndef	ENET_INC_HW_FPGA
extern b0RxTxMpduDesc_u B0_MpduDescriptorsDump;
extern b1RxTxMpduDesc_u B1_MpduDescriptorsDump;
#endif
#endif

#endif /*SHRAM_RX_DESCRIPTORS_H_ */

