/***************************************************************
 File:		ShramRxH.h
 Module:	  	Shram
 Purpose: 	holds the declerations of the RxH - FW interface structures 
 Description:  This file contains the declerations of the sender - FW interface structures
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_RXH_H_
#define SHRAM_RXH_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxHandler_InitApi.h"
#include "RxHandler_SnifferApi.h"
#include "RxManager_Api.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "RxhGenriscInitVector_Descriptors.h"
#endif

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#ifdef SNIFFER_MU_ENABLED
#define MAX_TRIGGER_FRAME_SIZE	(260) // 8 (commmon info) + 7*36 (per-user info for 36 users)
#endif //SNIFFER_MU_ENABLED

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//----------------------------------------------------------------------------------
#if defined (ENET_INC_ARCH_WAVE600)
#ifdef SNIFFER_MU_ENABLED
typedef struct snifferTriggerFrameParams
	{	 
		uint32 triggerFrameLength;
		uint32 reserved;
		uint8  triggerFrame[MAX_TRIGGER_FRAME_SIZE];
			
	} snifferTriggerFrameParams_t;
#endif // SNIFFER_MU_ENABLED
#endif

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
#if defined (ENET_INC_ARCH_WAVE600)
extern volatile RxhGenriscInitVector_t RxhInitializationStructure; 
extern volatile RxhGenriscInitVector_t RxhInitializationStructure_B1;
extern uint8  snifferHdrTemplatesRing[SNIFFER_TEMPLATE_RING_NUM_OF_ENTRIES][SNIFFER_HDR_TEMPLATE_SIZE_IN_BYTES];
#ifdef SNIFFER_MU_ENABLED
extern snifferTriggerFrameParams_t	   snifferTriggerFrameParams;
#endif //SNIFFER_MU_ENABLED
#else
extern volatile RxHParams_t RxhInitializationStructure; 
extern FwRxHandlerSnifferParams_t RxhSnifferParams;
#endif // (ENET_INC_ARCH_WAVE600)

#if defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)
extern clientModeMcastFilterRingElement_t clientModeMcastFilterRing[CLIENT_MODE_MCAST_FILTER_RING_SIZE];
#endif // defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)

#endif /*SHRAM_RXH_H_ */






