/***************************************************************
 File:		ShramRxPpFifo.h
 Module:	  	Shram
 Purpose: 	holds the declerations the RxPP fragments fifo
 Description:  This file contains the declerations of RxPp fragments fifo
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_RXPP_FIFO_H_
#define SHRAM_RXPP_FIFO_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"
 #ifdef ENET_INC_ARCH_WAVE600
#include "RxppFragFifo_Descriptors.h"
 #endif
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define RXPP_FRAGMENT_FIFO_DEPTH 		  16
#ifdef ENET_INC_ARCH_WAVE600
typedef  RxppFragFifo_t RxPpFifoFragStructure_t;
#else
typedef struct RxPpFifoFragStructure_
{
	uint32 	sn			:12;
	uint32  tid			:4;	
	uint32  stationId	:7;	
	uint32  fragStart	:1;	// Indicates if Fragment start(1) or fragment End(0)
	uint32	reserved	:8;
} RxPpFifoFragStructure_t;
#endif



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
extern RxPpFifoFragStructure_t RxPpShramFragmentFifo[RXPP_FRAGMENT_FIFO_DEPTH];


#endif /*SHRAM_RXF_FIFO_H_ */

