/***************************************************************
 File:		ShramRxfFifo.h
 Module:	  	Shram
 Purpose: 	holds the declerations the station database block 
 Description:  This file contains the declerations of the station database
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_RXF_FIFO_H_
#define SHRAM_RXF_FIFO_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

// FIFO RAM
#define RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH  		  16 /*set it to 2^*/
#define RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH_MASK (RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH - 1)


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

#if defined (ENET_INC_ARCH_WAVE600)

typedef union
{
	uint32 val;
	struct
	{
		uint32 address2Index : 8;  //bits [0..7]
		uint32 reserved0	 : 1;  //bit [8]
		uint32 vapId 		 : 5;  //bits [9..13]
		uint32 reserved1	 : 2;  //bits [14..15]
		uint32 tid 	 		 : 3;  //bits [16..18]
		uint32 reserved2	 : 13; //bits [19..31]
	} bitFields;
} RegRxfFifoLine_u; // same as RxfFifoShramCommon_t ( which is defined only for 600, so can't be used in 500)

#else

typedef union
{
	uint32 val;
	struct
	{
		uint8 address2Index;
		uint8 vapId    : 4;
		uint8 tid      : 3;
		uint8 reserved1: 1;
		uint16 reserved2;
	} bitFields;
} RegRxfFifoLine_u;

#endif


//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
extern RegRxfFifoLine_u RxfAmpduNoBaAggrementFifo[RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH];
#if defined (ENET_INC_ARCH_WAVE600)
extern RegRxfFifoLine_u RxfAmpduNoBaAggrementFifo_B1[RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH];
#endif


#endif /*SHRAM_RXF_FIFO_H_ */

