/***************************************************************
 File:		ShramSecurity.h
 Module:	  	Shram
 Purpose: 	holds the declerations of the Security structures 
 Description:  This file contains the declerations of the Security structures
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_SECURITY_H_
#define SHRAM_SECURITY_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"
#include "ccmp.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "gcmp.h"
#endif
#include "Utils_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define NUMBER_OF_TX_SECURITY_DESCRIPTOR   	64
#define NUMBER_OF_RX_SECURITY_DESCRIPTOR   	64

#define SECURITY_KEYS_NUM      				4   	/* The maximum number of keys */
#define SECURITY_KEY_LENGTH    				16  	/* Every key is 128 bit long. So Key length is 16 * uint8 */

#if defined (ENET_INC_ARCH_WAVE600)
#define SECURITY_INVALID_KEY_INDEX 			0xFFF  	/* Key index of value 0xffff is invalid */
#else
#define SECURITY_INVALID_KEY_INDEX 			0x7FF  	/* Key index of value 0xffff is invalid */
#endif

#define SIZE_OF_TKIP_FRAGMENT_DB_ENTRY   	20 //According to VLSI spec



typedef enum KeyId
{
	KEY_ID_0 = 0,
	KEY_ID_1,
	KEY_ID_2,
	KEY_ID_3,
	KEY_ID_NUM_OF_IDS,
	KEY_MAX_ID = 0xFF,
} KeyId_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Data Type Definition					
//----------------------------------------------------------------------------------

typedef struct SecurityDescriptor
{
	uint32 addressPointer1 :21; 
	uint32 keyEntryIndex   :11;  

	uint32 addressPointer2 :21;  
	uint32 micEntryIndex   :11;


	uint32 isEncryption      :1; 
	uint32 generateInterrupt :1;
	uint32 lastInRing        :1; 
	uint32 reserved1         :1; 
	uint32 encryptionType    :3; 
    uint32 sppAmsduCapable   :1;
    uint32 KeyId             :2;
    uint32 dataLength        :14;
    uint32 hwStatus          :1;
    uint32 failureIndication :1;
    uint32 micFailureIndication :1;
    uint32 keyNotValid       :1;
    uint32 frameNotProtected :1;
    uint32 lengthError       :1;
    uint32 eivFieldError     :1;
    uint32 tkipDecryptionFragError    :1;
} SecurityDescriptor_t;

/* Security API */
typedef struct Key
{
	uint8 actualKey[SECURITY_KEY_LENGTH];
} Key_t;	


typedef struct KeyValuesEntry
{
	Key_t keyValues[SECURITY_KEYS_NUM];
}	KeyValuesEntry;



//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------

#ifndef ENET_INC_ARCH_WAVE600 // In gen6 there are no SCPAD for Muted header and there are no security dscriptors
extern volatile SecurityDescriptor_t rxSecurityDescriptors[NUMBER_OF_RX_SECURITY_DESCRIPTOR];
extern volatile SecurityDescriptor_t txSecurityDescriptors[4][NUMBER_OF_TX_SECURITY_DESCRIPTOR];
extern uint8 mutedHeaderScratchPad[4][ALIGN4(CCMP_AAD_MAX_LENGTH)];
#endif

extern KeyValuesEntry KeysDatabase[];
extern uint8 tkipFragmentDb[];



#endif /*SHRAM_SECURITY_H_ */

