/***************************************************************
 File:		ShramSender.h
 Module:	  	Shram
 Purpose: 	holds the declerations of the sender - FW interface structures 
 Description:  This file contains the declerations of the sender - FW interface structures
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_SENDER_H_
#define SHRAM_SENDER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "TxSenderInitVector_Descriptors.h"
#else
#include "TxSender_InitApi.h"
#endif //ENET_INC_ARCH_WAVE600

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//----------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------

#if defined (ENET_INC_ARCH_WAVE600)

extern volatile TxSenderInitVector_t SenderInitializationStructure; 
extern volatile TxSenderInitVector_t SenderInitializationStructure_B1; 

#else

extern volatile SenderInterfaceParams_t SenderInitializationStructure; 

#endif //ENET_INC_ARCH_WAVE600

#endif /*SHRAM_SENDER_H_ */

