/***************************************************************
 File:		ShramStatistics.h
 Module:	  	Shram
 Purpose: 	holds the declerations of shram statistics buffer
 Description:  This file contains the allocation of the shram
			 statistics buffer which is used for DMA
***************************************************************/
#ifndef SHRAM_STATISTICS_H_
#define SHRAM_STATISTICS_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "MT_Build_Config.h"
#include "Statistics_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600
// Must be a multiply of sizeof(StatsEntryDecoded_t) for performance.
#define STATISTICS_MANAGER_SHRAM_BUFFER_SIZE   (1024)
#else
#define STATISTICS_MANAGER_SHRAM_BUFFER_SIZE   128
#endif



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#ifdef CPU_MIPS
#pragma alignvar (4)
#endif

MAP_TO_SECTION(bss, ".SHARED_RAM_STATISTIC_MANAGER")

extern uint8 StatisticsShramBuffer[STATISTICS_MANAGER_SHRAM_BUFFER_SIZE]; // Temporery buffer in Shared ram, use as a middle-man to copy Iram to Host.

MAP_TO_DEFAULT_SECTION(bss)


#ifdef CPU_MIPS
#pragma alignvar (4)
#endif
MAP_TO_SECTION(bss, ".SHARED_RAM_STATISTIC_MANAGER")
extern DynamicBwStatistics_t DynamicBwStatistics;

#ifdef ENET_INC_ARCH_WAVE600
extern uint32 CyclicBufferOverflowCounter[GEN6_NUM_OF_BANDS];
#else
extern uint32 CyclicBufferOverflowCounter;
#endif

extern uint32 LinkAdaptationVapFrameErrorCountBaseAddress;
extern uint32 LinkAdaptationWlanFrameErrorCountBaseAddress;
	   
extern LinkAdaptationStatistics_t 	LinkAdaptationStatistics;				  	// Link Adaptation statistics
extern LinkAdaptationMuStatistics_t LinkAdaptationMuStatistics;				  	// Link Adaptation statistics

extern PerClientStatistics_t 		PerClientStatistics;			   			// per client transmit statistics


MAP_TO_DEFAULT_SECTION(bss)


#endif /*#ifndef SHRAM_STATISTICS_H_ */

