/***************************************************************
 File:		ShramStd.h
 Module:	  	Shram
 Purpose: 	holds the declerations the Std 
 Description:  This file contains the declerations of the Std structure
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_STD_H_
#define SHRAM_STD_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	STD_WAIT_FOR_ACK = 0,
	STD_NO_WAIT_FOR_ACK = 1,
	STD_WAIT_FOR_BA = 3
} StdAckPolicy_e;

typedef enum
{
	STD_PHY_MODE_11A_OR_11G = 0,
	STD_PHY_MODE_11B = 1,
	STD_PHY_MODE_11N = 2,
	STD_PHY_MODE_11AC = 3,
} StdPhyMode_e;

typedef enum
{
	STD_PD_TYPE_DATA = 0,
	STD_PD_TYPE_NDP = 2,
	STD_PD_TYPE_ADDBA_REQ = 3,
	STD_PD_TYPE_BAR = 4,
	STD_PD_TYPE_CH_SWITCH_ANN = 5,
	STD_PD_TYPE_PS_QOS_NDP = 6,
	STD_PD_TYPE_NDPA_NDP_BF = 7,
	STD_PD_TYPE_MANAGEMENT_UNENC = 9,
	STD_PD_TYPE_MANAGEMENT_ENC = 11,
	STD_PD_TYPE_CONTROL_UNENC = 12,
	STD_PD_TYPE_CONTROL_ENC = 13,
	STD_PD_TYPE_MANAGEMENT_ENC_BIP = 14,
	STD_PD_TYPE_BEACON = 15,
} StdPD_TYPE_e;

//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------


#endif /*SHRAM_STD_H_ */

