/***************************************************************
 File:		ShramTxHandlerTimingParams.h
 Module:	  	Shram
 Purpose: 	holds the declerations the Tx handler timing parameters section
 Description:  This file contains the declerations of the Tx Handler timing parameters section
 			in the SHRAM
***************************************************************/
#ifndef SHRAM_TX_HANDLER_TIMING_PARAMS_H_
#define SHRAM_TX_HANDLER_TIMING_PARAMS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef struct HwAcTimingParams
{    
	/* word 0 */
    uint32 minimumContentionWindow :4;
	uint32 maximumContentionWindow :4;
	uint32 ssrc                    :8;
	uint32 slrc                    :8;
	uint32 currentContentionWindow :4;
	uint32 res1                     :4;
	
	/* word 1*/
	uint32 aifsn    :4;
	uint32 res2     :4;
	uint32 bo       :15;
	uint32 res3     :1;
	uint32 ifsn     :4;
	uint32 res4     :4;
} HwAcTimingParams_t;




//---------------------------------------------------------------------------------
//						global Variables					
//---------------------------------------------------------------------------------
extern HwAcTimingParams_t HwVapsAcsTimingParameters [HW_NUM_OF_VAPS][HW_AC_NUM_OF_PRIORITIES];
#if defined (ENET_INC_ARCH_WAVE600)
extern HwAcTimingParams_t HwVapsAcsTimingParameters_B1[HW_NUM_OF_VAPS][HW_AC_NUM_OF_PRIORITIES];
#endif





#endif /*SHRAM_TX_HANDLER_TIMING_PARAMS_H_ */

