/* shramTxDesc.h */
#ifndef SHRAM_TX_DESC_H_
#define SHRAM_TX_DESC_H_

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Information.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "OSAL_Api.h"
#include "shram_dataHostIf.h"
#include "PacketDescriptor.h"
#include "ResourceManager_API.h"

#if defined ENET_INC_ARCH_WAVE600
#ifndef ENET_INC_HW_FPGA
#define NUM_OF_TX_DESC		20480 // wave600 real chip
#else
#define NUM_OF_TX_DESC		4096 // wave600 FPGA
#endif
#else
#define NUM_OF_TX_DESC		4096 // wave500
#endif


#if defined ENET_INC_ARCH_WAVE600
#define NUM_OF_TS_MANAGER_DESCRIPTORS		(64) //maximum value is mandates by number of bits used by TS manager to store PD offset from TS pool and should be smaller than TS manager queue size
#define NUM_OF_RELIABLE_MCAST_DESCRIPTORS   (640)
#define NUM_OF_BSS_DESCRIPTORS				(256)
#define NUM_OF_CSA_MANAGER_DESCRIPTORS		(256)
#define NUM_OF_PS_SETTINGS_NDP_DESCRIPTORS	(256)
#define NUM_OF_MANAGEMENT_DESCRIPTORS		(32)
#define NUM_OF_MC_DEAUTH_DESCRIPTORS		(NUM_OF_VAPS)	/* Each VAP has a single MC DEAUTH frame */

#define BEACON_NUM_OF_TEMPLATES		 (HW_NUM_OF_VAPS + 4)
#endif //#if defined ENET_INC_ARCH_WAVE600

#if !defined (ENET_INC_ARCH_WAVE600)
#define NUM_OF_TS_MANAGER_DESCRIPTORS		(32) //maximum value is mandates by number of bits used by TS manager to store PD offset from TS pool
#define NUM_OF_RELIABLE_MCAST_DESCRIPTORS   (640)
#define NUM_OF_BSS_DESCRIPTORS				(128)
#define NUM_OF_CSA_MANAGER_DESCRIPTORS		(1)
#define NUM_OF_PS_SETTINGS_NDP_DESCRIPTORS	(8)
#define NUM_OF_MANAGEMENT_DESCRIPTORS		(1)

#define BEACON_NUM_OF_TEMPLATES		 (HW_NUM_OF_VAPS + 2)
#endif //#if !defined (ENET_INC_ARCH_WAVE600)



#define MAX_NUM_PDS_PER_BEACON				(9) /*beacon can be consists of up to 9 pds */
#define BEACON_NUM_OF_PDS_IN_POOL	 (BEACON_NUM_OF_TEMPLATES * MAX_NUM_PDS_PER_BEACON) 



typedef struct PdPools
{
	TxPd_t DataDescPool[NUM_OF_TX_DESC];
	reliableMcastPacketDescriptor_t ReliableMcastDescPool[NUM_OF_RELIABLE_MCAST_DESCRIPTORS];
	TxPd_t TsManDescPool[NUM_OF_TS_MANAGER_DESCRIPTORS];
	TxPd_t ManDescPool[NUM_OF_MANAGEMENT_DESCRIPTORS];
	TxPd_t BssDescPool[NUM_OF_BSS_DESCRIPTORS];
	TxPd_t CsaManDescPool[NUM_OF_CSA_MANAGER_DESCRIPTORS];
	TxPd_t PsSettingsNdpDescPool[NUM_OF_PS_SETTINGS_NDP_DESCRIPTORS];
	TxPd_t McDeauthDescPool[NUM_OF_MC_DEAUTH_DESCRIPTORS];
}PdPools_t;

extern uint8 TsManPackets[NUM_OF_TS_MANAGER_DESCRIPTORS][TS_PACKET_SIZE_ALLINGED_TO_WORDS];
extern ManPacket_t ManPkts[NUM_OF_MANAGEMENT_DESCRIPTORS];
extern CsaFrame_t CsaPkts[NUM_OF_CSA_MANAGER_DESCRIPTORS];

extern TxPd_t PdBeaconPoolArray[BEACON_NUM_OF_PDS_IN_POOL];
extern CSA_IE CsaIePayload[HW_NUM_OF_VAPS];
extern CSA_WRAPPER_IE CsaWrapperIePayload[HW_NUM_OF_VAPS];
extern BSS_LOAD_IE bssLoadIePayload[HW_NUM_OF_VAPS];

extern 	PdPools_t PdDescPools;


#endif //SHRAM_TX_DESC_H_
