#ifndef SHRAM_DATA_HOST_IF_INCLUDED_H
#define SHRAM_DATA_HOST_IF_INCLUDED_H


#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Information.h"
#include "ErrorHandler_Api.h"
#include "PacketDescriptor.h"
#include "HostInterfaceHw.h"



typedef enum
{
    BUFFER_STATUS_EMPTY,
    BUFFER_STATUS_FULL,
	NUM_OF_BUFFER_STATUS,
    HIM_BUF_STATUS_MAX = MAX_UINT8
} HimBufStatus_e;


typedef struct ShramHostIfRingsDb
{
	uint8 TxInShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][TX_IN_BUFFER_SIZE];
	uint8 TxOutShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][TX_OUT_BUFFER_SIZE];
	uint8 RxInShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][RX_IN_BUFFER_SIZE];
	uint8 RxOutShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][RX_OUT_BUFFER_SIZE];
	uint8 MangTxInShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][TX_IN_BUFFER_SIZE];
	uint8 MangTxOutShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][TX_OUT_BUFFER_SIZE];
	uint8 MangRxInShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][RX_IN_BUFFER_SIZE];
	uint8 MangRxOutShramBuffers[NUM_OF_SHARED_RAM_BUFFERS][RX_OUT_BUFFER_SIZE];
}ShramHostIfRingsDb_t;
#ifdef CPU_MIPS
#pragma alignvar (8)
#endif
extern ShramHostIfRingsDb_t ShramHostIfDb;

#endif //SHRAM_DATA_HOST_IF_INCLUDED_H

