/*******************************************************************************
*    
*   Source File: shram_hw_logger.h
*	
*	AUTHOR: Omer Gazit 
*
*   Description: SHRAM allocation of the HW logger module buffers
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

#ifndef SHRAM_HW_LOGGER_H_
#define SHRAM_HW_LOGGER_H_

#include "System_GlobalDefinitions.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "LoggerBd_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define NUM_OF_HW_LOGGER_SHRAM_BUFFERS		8 
#define HW_LOGGER_SHARED_RAM_BUFFER_SIZE	6000 
#define HW_LOGGER_SHARED_RAM_BUFFER_EXTRA_ALIGN16_SIZE  48 // assuming num of buffers is 2,4,6,8


//---------------------------------------------------------------------------------
//						Data structures						
//---------------------------------------------------------------------------------


#ifndef ENET_INC_ARCH_WAVE600 //Pre-Gen6 don't supported autogenerated descriptors header file
typedef struct LoggerBd
{ 
	void* shramMemoryAddr;
	uint32 nextBdPtr:16;
	uint32 currentBufferLength:14; 
	uint32 reserved:2;  	
}LoggerBd_t; 
#endif //ENET_INC_ARCH_WAVE600
	
typedef struct HwLoggerShramBuffer
{ 
	uint8 shramBufferWord[HW_LOGGER_SHARED_RAM_BUFFER_SIZE+HW_LOGGER_SHARED_RAM_BUFFER_EXTRA_ALIGN16_SIZE]; 
}HwLoggerShramBuffer_t; 

#ifdef CPU_MIPS
#pragma alignvar (16)
#endif

extern HwLoggerShramBuffer_t HwLoggerShramBuffers; 
extern LoggerBd_t HwLoggerShramBDs[NUM_OF_HW_LOGGER_SHRAM_BUFFERS];

#ifdef CPU_MIPS
#pragma alignvar (4)
#endif



#endif /*SHRAM_HW_LOGGER_H_*/ 


