
#ifndef SHRAM_INT_SECTION_INCLUDED_H
#define SHRAM_INT_SECTION_INCLUDED_H









typedef enum
{
    SHRAM_INT_RX_IN,
	SHRAM_INT_TX_IN,
	SHRAM_INT_ENC_DONE,
	SHRAM_INT_MANG_RX_IN,
	SHRAM_INT_MANG_TX_IN,
	SHRAM_INT_TX_APP_ERROR,
	NUM_OF_SHRAM_INT,
    SHRAM_INT_MAX = MAX_UINT8
} ShRamIntIsr_e;


ISR_VOID SharedRamInt_ISR(void);
void SharedRamInt_EnableInt(ShRamIntIsr_e intIndex);
void SharedRamInt_DisableInt(ShRamIntIsr_e intIndex);

void SharedRamInt_Init(void);

#ifdef CPU_MIPS
#pragma alignvar (64)	
#endif

extern	uint32 SharedRamIntSection[NUM_OF_SHRAM_INT];

#endif //SHRAM_INT_SECTION_INCLUDED_H



