/*******************************************************************************
*    
*   Source File: shram_logger_buffers.h
*	
*	AUTHOR: Ariel Groenteman
*
*   Description: SHRAM allocation of the logger module buffers
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

#ifndef SHRAM_LOGGER_BUFFERS_H_
#define SHRAM_LOGGER_BUFFERS_H_

#include "mhi_umi.h"
#include "System_GlobalDefinitions.h"
#include "MT_NSSMemoryPool.h"
#include "loggerDef.h"

#include "loggerAPI.h"


// Note: Logger Buffer Size is defined also in the .ld file:
// SHARED_RAM_LOGGER_SIZE and SHARED_RAM_LM_LOGGER_SIZE

#define LOGGER_REGULAR_BUFFERS_POOL_SIZE      (MT_POOL_SIZE(LOGGER_UM_BUFFER_SIZE, LOGGER_NUM_OF_BUFFERS))
#define LOGGER_REGULAR_LM_BUFFERS_POOL_SIZE      (MT_POOL_SIZE(LOGGER_LM_BUFFER_SIZE, LOGGER_NUM_OF_BUFFERS))

PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_LOGGER")

/* logger Vector Area */
extern BUFFER_DAT_IND_MSG_DESC ShramLoggerVectorAreaDescriptor[NUM_OF_LOGGER_BUFFER_DESCRIPTORS];

extern  uint8 shram_LoggerRegularBuffers[LOGGER_NUM_OF_BUFFERS][LOGGER_BUFFER_SIZE];


MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA




PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_LM_LOGGER")

extern  char shram_LmLoggerRegularBuffers[LOGGER_REGULAR_LM_BUFFERS_POOL_SIZE];

MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA


#endif /* SHRAM_LOGGER_BUFFERS_H_ */
