/* CMSynergyVer %full_filespec: shram_man_msgs.h;4.1.2.2.6:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET MAC: UM/LM FSDU storage
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_lower/shram_man_msgs.h $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         IFO
 **
 ** DESCRIPTION:    LMI management messages (may be in Shared RAM).
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **                     $Modtime:   $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom
 *
 ****************************************************************************/

#ifndef SHRAM_MAN_MSGS_INCLUDED
#define SHRAM_MAN_MSGS_INCLUDED

#include "lmi.h"
#include "frame.h"
#include "BSSmanager_API.h"
#include "linkAdaptation_api.h"
#include "ProcessManager_Api.h"


#define BEACON_MAX_HOST_BUFFERS_NUM		5


typedef struct _Lmi_Set2040CoexMode_t
{
	uint16 coexistenceEnabled;
} Lmi_Set2040CoexMode_t;

typedef struct BeaconCsaStartMsg_s
{
	uint16 time; // counter value = number of tbtt-s before switch * beacon interval [ms]; calculated by driver since both params are VAP specific yet apply to all VAPs in this case (valid only in switch_type==csa)
	uint8 primaryChannel;
	uint8 channelWidth;		// Bandwidth of the new channel
	uint8 csaChannelWidth;	// bandwidth encoding
	uint8 center0FreqIdx;	
#ifdef ENET_INC_ARCH_WAVE600
	uint8 center1FreqIdx;
#endif //ENET_INC_ARCH_WAVE600
	uint8 blockTx;
} BeaconCsaStartMsg_t;

typedef struct BeaconHostBuffer
{
	uint32  bufferAddress;
	uint16  bufferLength;
} BeaconHostBuffer_t;


typedef struct BeaconSetIEsBuffers
{
	BeaconHostBuffer_t  beaconBuffers[BEACON_MAX_HOST_BUFFERS_NUM];
	uint8   vapIdx;		   // index of the VAP 
	bool	addBssLoadIe;
} BeaconSetIEsBuffers_t;

typedef struct BeaconCsaPdMsg_s
{
	void					*pd;
} BeaconCsaPdMsg_t;

typedef struct BeaconBlockingSetMsg_s
{
	uint32 initial; /* blocked to unblocked */
	uint32 iterative; /* unblocked to blocked */
	bool enableBlocking;
} BeaconBlockingSetMsg_t;


typedef enum
{	
	BEACON_HOST_PART1_BUFFER = 0,
	BEACON_HOST_PART2_BUFFER,
	BEACON_HOST_PART3_BUFFER,
	BEACON_HOST_PART4_BUFFER,
	BEACON_HOST_PART5_BUFFER,
	BEACON_HOST_NUM_OF_BUFFERS,
} BeaconHostBufferParts_e;


//IPC messages
#define SH_RAM_MSG_SIZE 64
#define NO_SH_RAM_MSGS 20


typedef struct SH_RAM_PARAMS_s
{
	uint8 data[SH_RAM_MSG_SIZE];
} SH_RAM_PARAMS;

typedef struct SH_RAM_MESSAGE_s
{
    K_MSG_HEADER            sKmsgHeader;
    SH_RAM_PARAMS  			sParams;
} SH_RAM_MESSAGE;

PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_IPC_MSGS")

extern FwUtils_queue_t shRamMsgQ;
extern SH_RAM_MESSAGE  asShRamMsgAlloc[NO_SH_RAM_MSGS];//[NO_SH_RAM_MSGS];

MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA


#endif /* SHRAM_MAN_MSGS_INCLUDED */
