/***************************************************************
 File:		ShramAutoResponseFifos.c
 Module:		Shram
 Purpose: 	holds the allocation in memory of the Auto Response error FIFOs 
 Description:  This file contains the allocation of the Auto Response error FIFOs 
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "AutoResponse_Api.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#if defined (ENET_INC_ARCH_WAVE600)

MAP_TO_SECTION(bss, ".SHARED_RAM_AUTO_RESPONSE_ERROR_FIFO")
AutoRespErrFifo_t AutoResponseErrorFifo[AUTO_RESPONSE_ERROR_FIFO_SIZE]; 
MAP_TO_DEFAULT_SECTION(bss)


MAP_TO_SECTION(bss, ".SHARED_RAM_AUTO_RESPONSE_ERROR_FIFO_B1")
AutoRespErrFifo_t AutoResponseErrorFifo_B1[AUTO_RESPONSE_ERROR_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)

#endif



