/***************************************************************
 File:		   ShramBaAnalyzerFifos.c
 Module:	   Shram
 Purpose: 	   holds the allocation in memory of the BA analyzer 
 			   status FIFO 
 Description:  This file contains the allocation of the BA 
 			   analyzer status FIFO 
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramBaAnalyzerFifos.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

// BAA Status Fifo
#ifndef ENET_INC_ARCH_WAVE600
MAP_TO_SECTION(bss, ".SHARED_RAM_BA_ANALYZER_STATUS_FIFO")
BaAnalyzerStatus_t BaAnalyzerStatusFifo[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; 
MAP_TO_DEFAULT_SECTION(bss)
#else

MAP_TO_SECTION(bss, ".SHARED_RAM_BA_ANALYZER_STATUS_FIFO")
BaaTxStatusFifo_t BaAnalyzerStatusFifo[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; // FIFO used for band 0
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_BA_ANALYZER_STATUS_FIFO_B1")
BaaTxStatusFifo_t BaAnalyzerStatusFifo_B1[BA_ANALYZER_MAC_STATUS_FIFO_SIZE]; // FIFO used for band 1
MAP_TO_DEFAULT_SECTION(bss)

#endif // ENET_INC_ARCH_WAVE600


#ifndef ENET_INC_ARCH_WAVE600
// BAA reports
MAP_TO_SECTION(bss, ".SHARED_RAM_TX_BAA_REPORTS_FIFO")
BaaRateAdaptiveFifo_t baaFifoReport[MAX_TX_BAA_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)

#else

MAP_TO_SECTION(bss, ".SHARED_RAM_TX_BAA_REPORTS_FIFO")
BaaRateAdaptiveCommonFifo_t BaAnalyzerRaCommonReportFifo[BAA_COMMON_FIFO_SIZE];
BaaRateAdaptiveUserFifo_t	BaAnalyzerRaUserReportFifo[BAA_USER_FIFO_SIZE];


MAP_TO_SECTION(bss, ".SHARED_RAM_TX_BAA_REPORTS_FIFO_B1")
BaaRateAdaptiveCommonFifo_t BaAnalyzerRaCommonReportFifo_B1[BAA_COMMON_FIFO_SIZE];
BaaRateAdaptiveUserFifo_t	BaAnalyzerRaUserReportFifo_B1[BAA_USER_FIFO_SIZE];

MAP_TO_DEFAULT_SECTION(bss)


#endif




