/***************************************************************
 File:		ShramRxfFifo.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of Rxf fifo.
 			Fifo line indicates recive of an A-MPDU frame with no BA agreement open.
 Description:  This file contains the allocation of the RXF fifo block
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#ifdef ENET_INC_ARCH_WAVE600D2
#include "MbfmErrFifo_Descriptors.h"
#endif
#include "ShramBeamforming.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600D2
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO")
MbfmErrFifo_t BeamformingErrorFifo[(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; 
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO_B1")
MbfmErrFifo_t BeamformingErrorFifo_B1[(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; 
MAP_TO_DEFAULT_SECTION(bss)
#else //ENET_INC_ARCH_WAVE600D2
#ifdef ENET_INC_ARCH_WAVE600
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO")
uint32  BeamformingErrorFifo[2*(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; // Each entry is 2 words (8 bytes)
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING_ERROR_FIFO_B1")
uint32  BeamformingErrorFifo_B1[2*(HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE + 1)]; // Each entry is 2 words (8 bytes)
MAP_TO_DEFAULT_SECTION(bss)

#else
MAP_TO_SECTION(bss, ".SHARED_RAM_BEAMFORMING")
BeamFormingDatabase_t BeamformingDatabase[HW_NUM_OF_STATIONS + 1];
uint8 BeamformingIndexesTable[HW_NUM_OF_STATIONS];
MAP_TO_DEFAULT_SECTION(bss)
#endif //ENET_INC_ARCH_WAVE600
#endif //ENET_INC_ARCH_WAVE600D2


