/***************************************************************
 File:		ShramDeliaDescriptors.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the Delia descriptors 
 Description:  This file contains the allocation of the Delia descriptors
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramDeliaDescriptors.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
MAP_TO_SECTION(bss, ".SHARED_RAM_DELIA_DESCRIPTORS")
#ifdef ENET_INC_ARCH_WAVE600
Deliad_t DeliaDataStructure;
#else
uint32 DeliaDescriptors[4][DELIA_COMMOM_DESCRIPTOR_SIZE + (DELIA_DESCRIPTOR_SIZE * DELIA_MAX_DESCRIPTORS)]; 
#endif //ENET_INC_ARCH_WAVE600
MAP_TO_DEFAULT_SECTION(bss)

#ifdef ENET_INC_ARCH_WAVE600
MAP_TO_SECTION(bss, ".SHARED_RAM_DELIA_DESCRIPTORS_B1")
Deliad_t DeliaDataStructure_B1;
MAP_TO_DEFAULT_SECTION(bss)
#endif //ENET_INC_ARCH_WAVE600




