/***************************************************************
 File:		ShramDmacWrapper.c
 Module:	  	Shram
 Purpose: 	holds the buffers that contain the manipulation lists and the programs of the DMAC
 Description:   holds the buffers that contain the manipulation lists and the programs of the DMAC
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramDmacWrapper.h"
#include "ConfigurationManager_api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/



MAP_TO_SECTION(bss, ".SHARED_RAM_DMAC_WRAPPER")

#ifdef ENET_INC_ARCH_WAVE600

// In Gen6 we have 2 instances (per band). Start address must be aligned to 32 bytes, and order within struct must not be changed
dmaWrapperDb_t DmaWrapperDb[NUM_OF_CONFIGURATION_MANAGER_BANDS];
#pragma Align_to(32,DmaWrapperDb)

#else

// In gen5 we have only 1 instance
#pragma alignvar (8)
dmaWrapperDb_t DmaWrapperDb;
#pragma alignvar (4)

#endif

MAP_TO_DEFAULT_SECTION(bss)




